/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;

public class CompositeResourceLoader
implements ResourceLoaderExtended {
    private ResourceLoader[] resourceLoaders;
    private ResourceLoader callBackLoader;

    public CompositeResourceLoader(ResourceLoader ... resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
    }

    @Override
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        InputStream inputStream = null;
        for (ResourceLoader loader : this.resourceLoaders) {
            inputStream = loader instanceof ResourceLoaderExtended ? ((ResourceLoaderExtended)loader).fetchResource(resourceName, callback) : loader.fetchResource(resourceName);
            if (inputStream == null) continue;
            this.callBackLoader = loader;
            break;
        }
        return inputStream;
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    @Override
    public URI getUriCallBackParam() {
        if (this.callBackLoader != null && this.callBackLoader instanceof ResourceLoaderExtended) {
            return ((ResourceLoaderExtended)this.callBackLoader).getUriCallBackParam();
        }
        return null;
    }
}

