/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.snakeyaml;

import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.snakeyaml.SYModelWrapper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class NodeParser {
    @Nullable
    public static Node parse(ResourceLoader resourceLoader, String resourcePath, Reader reader) {
        try {
            Yaml yamlParser = new Yaml();
            org.yaml.snakeyaml.nodes.Node composedNode = yamlParser.compose(reader);
            if (composedNode == null) {
                return null;
            }
            return new SYModelWrapper(resourceLoader, resourcePath).wrap(composedNode);
        }
        catch (MarkedYAMLException e) {
            return NodeParser.buildYamlErrorNode(e);
        }
    }

    private static Node buildYamlErrorNode(MarkedYAMLException e) {
        ErrorNode errorNode = new ErrorNode("Underlying error while parsing YAML syntax: '" + e.getMessage() + "'");
        Mark problemMark = e.getProblemMark();
        errorNode.setStartPosition(new DefaultPosition(problemMark.getIndex(), problemMark.getLine(), 0, "", new DefaultResourceLoader()));
        errorNode.setEndPosition(new DefaultPosition(problemMark.getIndex() + 1, problemMark.getLine(), problemMark.getColumn(), "", new DefaultResourceLoader()));
        return errorNode;
    }

    @Nullable
    public static Node parse(ResourceLoader resourceLoader, String resourcePath, String content) {
        return NodeParser.parse(resourceLoader, resourcePath, new StringReader(content));
    }
}

