/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.AlwaysRequiredField;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.DefaultValue;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.RequiredField;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.grammar.rule.StringValueRule;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class KeyValueRule
extends Rule {
    private Rule keyRule;
    private Rule valueRule;
    private String description;
    private RequiredField requiredField;
    private DefaultValue defaultValue;
    private boolean matchValue = false;

    public KeyValueRule(Rule keyRule, Rule valueRule) {
        this.keyRule = keyRule;
        this.valueRule = valueRule;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return this.getValueRule().getSuggestions(node, context);
    }

    @Nonnull
    public List<Suggestion> getKeySuggestions(Node node, ParsingContext context) {
        List<Suggestion> suggestions = this.getKeyRule().getSuggestions(node, context);
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        Iterator<Suggestion> iterator = suggestions.iterator();
        while (iterator.hasNext()) {
            Suggestion suggestion;
            Suggestion keySuggest = suggestion = iterator.next();
            if (this.description != null) {
                keySuggest = suggestion.withDescription(this.description);
            }
            keySuggest = keySuggest.withValue(suggestion.getValue() + ": ");
            result.add(keySuggest);
        }
        return result;
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, ParsingContext context) {
        if (!pathToRoot.isEmpty()) {
            return this.valueRule.getSuggestions(pathToRoot.subList(1, pathToRoot.size()), context);
        }
        return super.getSuggestions(pathToRoot, context);
    }

    @Override
    public List<? extends Rule> getChildren() {
        return Arrays.asList(this.getKeyRule(), this.getValueRule());
    }

    public KeyValueRule description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof KeyValueNode) {
            KeyValueNode keyValueNode = (KeyValueNode)node;
            boolean matches = this.getKeyRule().matches(keyValueNode.getKey());
            return matches && (!this.matchValue || this.getValueRule().matches(keyValueNode.getValue()));
        }
        return false;
    }

    public KeyValueRule matchValue() {
        this.matchValue = true;
        return this;
    }

    public boolean repeated() {
        return !(this.getKeyRule() instanceof StringValueRule);
    }

    public Rule getKeyRule() {
        return this.keyRule;
    }

    public Rule getValueRule() {
        return this.valueRule;
    }

    public void setValueRule(Rule valueRule) {
        this.valueRule = valueRule;
    }

    public void setKeyRule(Rule keyRule) {
        this.keyRule = keyRule;
    }

    @Override
    public KeyValueRule then(Class<? extends Node> clazz) {
        super.then(clazz);
        return this;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!(node instanceof KeyValueNode)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.KeyValue);
        }
        if (!this.getKeyRule().matches(((KeyValueNode)node).getKey())) {
            return this.getKeyRule().apply(node);
        }
        KeyValueNode keyValueNode = (KeyValueNode)node;
        Node key = keyValueNode.getKey();
        key.replaceWith(this.getKeyRule().apply(key));
        Node value = keyValueNode.getValue();
        value.replaceWith(this.getValueRule().apply(value));
        return this.createNodeUsingFactory(keyValueNode, new Object[0]);
    }

    @Override
    public String getDescription() {
        return this.getKeyRule().getDescription() + ": " + this.getValueRule().getDescription();
    }

    @Nonnull
    public KeyValueRule required() {
        this.requiredField = AlwaysRequiredField.getInstance();
        return this;
    }

    @Nonnull
    public KeyValueRule requiredWhen(RequiredField requiredField) {
        this.requiredField = requiredField;
        return this;
    }

    public boolean isRequired(Node parent) {
        return this.requiredField != null && this.requiredField.isRequiredField(parent);
    }

    public KeyValueRule cleanDefaultValue() {
        this.defaultValue = null;
        return this;
    }

    @Nonnull
    public KeyValueRule defaultValue(DefaultValue defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public void applyDefault(Node parent) {
        if (this.defaultValue == null) {
            return;
        }
        StringValueRule keyRule = this.getStringKeyRule(this.getKeyRule());
        Node valueNode = this.defaultValue.getDefaultValue(parent);
        if (valueNode == null) {
            return;
        }
        StringNodeImpl keyNode = new StringNodeImpl(keyRule.getValue());
        KeyValueNodeImpl newNode = new KeyValueNodeImpl(keyNode, valueNode);
        newNode.setEndPosition(DefaultPosition.emptyPosition());
        newNode.setStartPosition(DefaultPosition.emptyPosition());
        parent.addChild(newNode);
    }

    private StringValueRule getStringKeyRule(Rule keyRule) {
        if (keyRule instanceof AnyOfRule) {
            keyRule = this.getStringKeyRule(((AnyOfRule)keyRule).getRules().get(0));
        }
        if (!(keyRule instanceof StringValueRule)) {
            throw new RuntimeException("Key rule " + keyRule.getClass().getSimpleName() + " does not support default values");
        }
        return (StringValueRule)keyRule;
    }
}

