/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class DivisorValueRule
extends Rule {
    private Number divisorValue;

    public DivisorValueRule(Number divisorValue) {
        this.divisorValue = divisorValue;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode) {
            if (this.divisorValue.intValue() == 0 && Integer.valueOf(0).equals(((IntegerNode)node).getValue())) {
                return true;
            }
            return this.divisorValue.intValue() != 0 && ((IntegerNode)node).getValue() % this.divisorValue.intValue() == 0;
        }
        if (node instanceof FloatingNode) {
            BigDecimal value = new BigDecimal(this.divisorValue.toString());
            if (value.compareTo(BigDecimal.ZERO) == 0 && ((FloatingNode)node).getValue().compareTo(BigDecimal.ZERO) == 0) {
                return true;
            }
            return value.compareTo(BigDecimal.ZERO) != 0 && ((FloatingNode)node).getValue().remainder(value).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getValue());
        }
        if (node instanceof IntegerNode && this.divisorValue.intValue() == 0 || node instanceof FloatingNode && this.divisorValue.floatValue() == 0.0f) {
            return ErrorNodeFactory.createInvalidDivisorValue();
        }
        return ErrorNodeFactory.createInvalidMultipleOfValue(this.divisorValue);
    }

    @Override
    public String getDescription() {
        return "Multiple of value";
    }
}

