/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes;

import java.util.Stack;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.nodes.AbstractRamlNode;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.SimpleTypeNode;

public class ErrorNode
extends AbstractRamlNode {
    private final String errorMessage;
    private String path;

    public ErrorNode(String msg) {
        this.errorMessage = msg;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getPath() {
        if (this.path == null) {
            Node previousNode = this;
            Stack<String> keysStack = new Stack<String>();
            for (Node currentNode = previousNode.getParent(); currentNode != null; currentNode = currentNode.getParent()) {
                Node key;
                if (currentNode instanceof ArrayNode) {
                    keysStack.push(String.valueOf(currentNode.getChildren().indexOf(previousNode)));
                } else if (currentNode instanceof KeyValueNode && (key = ((KeyValueNode)currentNode).getKey()) != null) {
                    String currentKey = ((SimpleTypeNode)key).getLiteralValue().replace("/", "~1");
                    keysStack.push(currentKey);
                }
                previousNode = currentNode;
            }
            StringBuilder fullPath = new StringBuilder();
            while (!keysStack.isEmpty()) {
                fullPath.append("/").append((String)keysStack.pop());
            }
            this.path = fullPath.length() > 0 ? fullPath.toString() : "/";
        }
        return this.path;
    }

    @Override
    @Nonnull
    public Node copy() {
        return this;
    }

    @Override
    public NodeType getType() {
        return NodeType.Error;
    }

    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), this.getErrorMessage());
    }
}

