/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import com.google.common.collect.Range;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.yagi.framework.grammar.rule.AbstractTypeRule;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class IntegerTypeRule
extends AbstractTypeRule {
    @Nullable
    private Range<Long> range;

    public IntegerTypeRule(@Nullable Range<Long> range) {
        this.range = range;
    }

    public IntegerTypeRule() {
        this(null);
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode) {
            return this.range == null || this.range.contains((Comparable)((IntegerNode)node).getValue());
        }
        if (node instanceof StringNode) {
            try {
                Long value = Long.parseLong(((StringNode)node).getValue());
                return this.range == null || this.range.contains((Comparable)value);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Integer";
    }

    @Override
    @Nonnull
    NodeType getType() {
        return NodeType.Integer;
    }
}

