/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.lang.reflect.Type;
import java.util.List;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.MapTupleRule;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class PojoTupleRule
extends DefaultTupleRule<ScalarNode, MappingNode> {
    private Class<?> pojoClass;

    public PojoTupleRule(String fieldName, Class<?> pojoClass, NodeRuleFactory nodeRuleFactory) {
        this(fieldName, pojoClass);
        this.setNodeRuleFactory(nodeRuleFactory);
    }

    public PojoTupleRule(String fieldName, Class<?> pojoClass) {
        super(fieldName, new DefaultScalarTupleHandler(fieldName));
        this.pojoClass = pojoClass;
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        if (this.rules.isEmpty()) {
            this.addRulesFor(this.pojoClass);
        }
        return super.getRuleForTuple(nodeTuple);
    }

    @Override
    public Class<?>[] getValueNodeType() {
        return new Class[]{MappingNode.class};
    }

    @Override
    public void setValueType(Type valueType) {
        this.pojoClass = (Class)valueType;
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        List<ValidationResult> validationResults = super.validateKey(key);
        if (this.getParentTupleRule() instanceof MapTupleRule) {
            ((MapTupleRule)this.getParentTupleRule()).checkDuplicate(key, validationResults);
        }
        return validationResults;
    }

    @Override
    public TupleRule<?, ?> deepCopy() {
        this.checkClassToCopy(PojoTupleRule.class);
        PojoTupleRule copy = new PojoTupleRule(this.getName(), this.pojoClass, this.getNodeRuleFactory());
        copy.setHandler(this.getHandler());
        copy.setRequired(this.isRequired());
        return copy;
    }
}

