/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.lang.reflect.Field;
import java.util.List;
import org.raml.model.Raml;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.ImplicitMapEntryRule;
import org.raml.parser.rule.NodeRule;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.visitor.MediaTypeResolver;
import org.raml.parser.visitor.TemplateResolver;
import org.raml.parser.visitor.YamlDocumentValidator;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RamlDocumentValidator
extends YamlDocumentValidator {
    private TemplateResolver templateResolver;
    private MediaTypeResolver mediaTypeResolver = new MediaTypeResolver();
    private ResourceLoader resourceLoader;

    public RamlDocumentValidator() {
        super(Raml.class);
    }

    public RamlDocumentValidator(NodeRuleFactory nodeRuleFactory) {
        super(Raml.class, nodeRuleFactory);
    }

    public TemplateResolver getTemplateResolver() {
        if (this.templateResolver == null) {
            this.templateResolver = new TemplateResolver(this.resourceLoader, this);
        }
        return this.templateResolver;
    }

    public MediaTypeResolver getMediaTypeResolver() {
        return this.mediaTypeResolver;
    }

    @Override
    public void onMappingNodeStart(MappingNode mappingNode) {
        super.onMappingNodeStart(mappingNode);
        NodeRule<?> rule = this.getRuleContext().peek();
        if (this.isResourceRule(rule)) {
            List<ValidationResult> templateValidations = this.getTemplateResolver().resolve(mappingNode, this.getResourceUri(rule), this.getFullUri(rule));
            this.getMessages().addAll(templateValidations);
        } else if (this.isBodyRule(rule)) {
            List<ValidationResult> mediaTypeValidations = this.getMediaTypeResolver().resolve(mappingNode);
            this.getMessages().addAll(mediaTypeValidations);
        }
    }

    private String getResourceUri(NodeRule<?> resourceRule) {
        Object keyNode = ((DefaultTupleRule)resourceRule).getKey();
        return ((ScalarNode)keyNode).getValue();
    }

    private String getFullUri(NodeRule<?> resourceRule) {
        String fullUri = "";
        while (resourceRule instanceof ImplicitMapEntryRule) {
            Object keyNode = ((DefaultTupleRule)resourceRule).getKey();
            fullUri = ((ScalarNode)keyNode).getValue() + fullUri;
            resourceRule = ((DefaultTupleRule)resourceRule).getParentTupleRule();
        }
        return fullUri;
    }

    private boolean isBodyRule(NodeRule<?> rule) {
        try {
            Field valueType = rule.getClass().getDeclaredField("valueType");
            valueType.setAccessible(true);
            return ((Class)valueType.get(rule)).getName().equals("org.raml.model.MimeType");
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private boolean isResourceRule(NodeRule<?> rule) {
        try {
            Field valueType = rule.getClass().getDeclaredField("valueType");
            valueType.setAccessible(true);
            return ((Class)valueType.get(rule)).getName().equals("org.raml.model.Resource");
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

