/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Inflector {
    private static List<String[]> singulars = new ArrayList<String[]>();
    private static List<String[]> plurals = new ArrayList<String[]>();
    private static List<String[]> irregulars = new ArrayList<String[]>();
    private static List<String> uncountables = new ArrayList<String>();

    private static void addPlural(String rule, String replacement) {
        plurals.add(0, new String[]{rule, replacement});
    }

    private static void addSingular(String rule, String replacement) {
        singulars.add(0, new String[]{rule, replacement});
    }

    private static void addIrregular(String rule, String replacement) {
        irregulars.add(new String[]{rule, replacement});
    }

    private static String gsub(String word, String rule, String replacement) {
        Pattern pattern = Pattern.compile(rule, 2);
        Matcher matcher = pattern.matcher(word);
        return matcher.find() ? matcher.replaceFirst(replacement) : null;
    }

    public static String pluralize(String word) {
        if (uncountables.contains(word)) {
            return word;
        }
        for (String[] irregular : irregulars) {
            if (!irregular[0].equalsIgnoreCase(word)) continue;
            return irregular[1];
        }
        for (String[] pair : plurals) {
            String plural = Inflector.gsub(word, pair[0], pair[1]);
            if (plural == null) continue;
            return plural;
        }
        return word;
    }

    public static String singularize(String word) {
        if (uncountables.contains(word)) {
            return word;
        }
        for (String[] irregular : irregulars) {
            if (!irregular[1].equalsIgnoreCase(word)) continue;
            return irregular[0];
        }
        for (String[] pair : singulars) {
            String singular = Inflector.gsub(word, pair[0], pair[1]);
            if (singular == null) continue;
            return singular;
        }
        return word;
    }

    private static String tableize(String camelCase) {
        return Inflector.pluralize(Inflector.underscore(camelCase));
    }

    private static String underscore(String camel) {
        ArrayList<Integer> upper = new ArrayList<Integer>();
        byte[] bytes = camel.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b >= 97 && b <= 122) continue;
            upper.add(i);
        }
        StringBuffer b = new StringBuffer(camel);
        for (int i = upper.size() - 1; i >= 0; --i) {
            Integer index = (Integer)upper.get(i);
            if (index == 0) continue;
            b.insert((int)index, "_");
        }
        return b.toString().toLowerCase();
    }

    public static String camelize(String dash) {
        return Inflector.camelize(dash, true);
    }

    private static String camelize(String dash, boolean capitalizeFirstChar) {
        String result = "";
        StringTokenizer st = new StringTokenizer(dash, "-");
        while (st.hasMoreTokens()) {
            result = result + Inflector.capitalize(st.nextToken());
        }
        return capitalizeFirstChar ? result : result.substring(0, 1).toLowerCase() + result.substring(1);
    }

    public static String capitalize(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    private static String shortName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static String getIdName(String tableName) {
        String idName = Inflector.singularize(tableName) + "_id";
        return idName.toLowerCase();
    }

    private static String getOtherName(String source, String target) {
        if (!target.contains(source) || target.equals(source)) {
            return null;
        }
        int start = target.indexOf(source);
        String other = start == 0 ? target.substring(source.length()) : target.substring(0, start);
        if (other.startsWith("_")) {
            other = other.replaceFirst("_", " ");
        }
        if (other.endsWith("_")) {
            byte[] otherb = other.getBytes();
            otherb[otherb.length - 1] = 32;
            other = new String(otherb);
        }
        return other.trim();
    }

    static {
        Inflector.addPlural("$", "s");
        Inflector.addPlural("s$", "s");
        Inflector.addPlural("(ax|test)is$", "$1es");
        Inflector.addPlural("(octop|vir)us$", "$1i");
        Inflector.addPlural("(alias|status)$", "$1es");
        Inflector.addPlural("(bu)s$", "$1ses");
        Inflector.addPlural("(buffal|tomat)o$", "$1oes");
        Inflector.addPlural("([ti])um$", "$1a");
        Inflector.addPlural("sis$", "ses");
        Inflector.addPlural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        Inflector.addPlural("(hive)$", "$1s");
        Inflector.addPlural("([^aeiouy]|qu)y$", "$1ies");
        Inflector.addPlural("(x|ch|ss|sh)$", "$1es");
        Inflector.addPlural("(matr|vert|ind)(?:ix|ex)$", "$1ices");
        Inflector.addPlural("([m|l])ouse$", "$1ice");
        Inflector.addPlural("^(ox)$", "$1en");
        Inflector.addPlural("(quiz)$", "$1zes");
        Inflector.addSingular("s$", "");
        Inflector.addSingular("(n)ews$", "$1ews");
        Inflector.addSingular("([ti])a$", "$1um");
        Inflector.addSingular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1sis");
        Inflector.addSingular("(^analy)ses$", "$1sis");
        Inflector.addSingular("([^f])ves$", "$1fe");
        Inflector.addSingular("(hive)s$", "$1");
        Inflector.addSingular("(tive)s$", "$1");
        Inflector.addSingular("([lr])ves$", "$1f");
        Inflector.addSingular("([^aeiouy]|qu)ies$", "$1y");
        Inflector.addSingular("(s)eries$", "$1eries");
        Inflector.addSingular("(m)ovies$", "$1ovie");
        Inflector.addSingular("(x|ch|ss|sh)es$", "$1");
        Inflector.addSingular("([m|l])ice$", "$1ouse");
        Inflector.addSingular("(bus)es$", "$1");
        Inflector.addSingular("(o)es$", "$1");
        Inflector.addSingular("(shoe)s$", "$1");
        Inflector.addSingular("(cris|ax|test)es$", "$1is");
        Inflector.addSingular("(octop|vir)i$", "$1us");
        Inflector.addSingular("(alias|status)es$", "$1");
        Inflector.addSingular("^(ox)en", "$1");
        Inflector.addSingular("(vert|ind)ices$", "$1ex");
        Inflector.addSingular("(matr)ices$", "$1ix");
        Inflector.addSingular("(quiz)zes$", "$1");
        Inflector.addSingular("(database)s$", "$1");
        Inflector.addIrregular("person", "people");
        Inflector.addIrregular("man", "men");
        Inflector.addIrregular("child", "children");
        Inflector.addIrregular("sex", "sexes");
        Inflector.addIrregular("move", "moves");
        Inflector.addIrregular("foot", "feet");
        Inflector.addIrregular("tooth", "teeth");
        uncountables = Arrays.asList("equipment", "information", "rice", "money", "species", "series", "fish", "sheep");
    }
}

