/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.tagresolver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.NodeHandler;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class IncludeResolver
implements TagResolver {
    public static final Tag INCLUDE_TAG = new Tag("!include");

    public boolean handles(Tag tag) {
        return INCLUDE_TAG.equals((Object)tag);
    }

    public Node resolve(Node node, ResourceLoader resourceLoader, NodeHandler nodeHandler) {
        Object includeNode;
        InputStream inputStream = null;
        try {
            ScalarNode scalarNode = (ScalarNode)node;
            String resourceName = scalarNode.getValue();
            inputStream = resourceLoader.fetchResource(resourceName);
            if (inputStream == null) {
                nodeHandler.onCustomTagError(INCLUDE_TAG, node, "Include can not be resolved " + resourceName);
                includeNode = new ScalarNode(Tag.STR, resourceName, node.getStartMark(), node.getEndMark(), scalarNode.getStyle());
            } else if (resourceName.endsWith(".raml") || resourceName.endsWith(".yaml") || resourceName.endsWith(".yml")) {
                Yaml yamlParser = new Yaml();
                includeNode = yamlParser.compose((Reader)new InputStreamReader(inputStream));
            } else {
                String newValue = IOUtils.toString((InputStream)inputStream);
                includeNode = new IncludeScalarNode(resourceName, newValue, scalarNode);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return includeNode;
    }

    public static class IncludeScalarNode
    extends ScalarNode {
        private String includeName;

        public IncludeScalarNode(String includeName, String value, ScalarNode node) {
            super(Tag.STR, value, node.getStartMark(), node.getEndMark(), node.getStyle());
            this.includeName = includeName;
        }

        public String getIncludeName() {
            return this.includeName;
        }
    }
}

