/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.utils.ConvertUtils;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRule
extends DefaultTupleRule<ScalarNode, ScalarNode> {
    private static final String EMPTY_MESSAGE = "can not be empty";
    private static final String DUPLICATE_MESSAGE = "Duplicate";
    private static final String TYPE_MISMATCH_MESSAGE = "Type mismatch: ";
    private ScalarNode keyNode;
    private ScalarNode valueNode;
    private Class<?> fieldClass;

    public SimpleRule(String fieldName, Class<?> fieldClass) {
        super(fieldName, new DefaultScalarTupleHandler(ScalarNode.class, fieldName));
        this.setFieldClass(fieldClass);
    }

    public static String getRuleEmptyMessage(String ruleName) {
        return ruleName + " " + EMPTY_MESSAGE;
    }

    public static String getDuplicateRuleMessage(String ruleName) {
        return "Duplicate " + ruleName;
    }

    public String getRuleTypeMisMatch(String fieldType) {
        return TYPE_MISMATCH_MESSAGE + this.getName() + " must be of type " + fieldType;
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        List<ValidationResult> validationResults = super.validateKey(key);
        if (this.wasAlreadyDefined()) {
            validationResults.add(ValidationResult.createErrorResult(SimpleRule.getDuplicateRuleMessage(this.getName()), key.getStartMark(), key.getEndMark()));
        }
        this.setKeyNode(key);
        return validationResults;
    }

    @Override
    public List<ValidationResult> validateValue(ScalarNode node) {
        String value = node.getValue();
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (StringUtils.isEmpty((String)value)) {
            validationResults.add(ValidationResult.createErrorResult(SimpleRule.getRuleEmptyMessage(this.getName()), this.keyNode.getStartMark(), this.keyNode.getEndMark()));
        }
        if (!ConvertUtils.canBeConverted(value, this.getFieldClass())) {
            validationResults.add(ValidationResult.createErrorResult(this.getRuleTypeMisMatch(this.getFieldClass().getSimpleName()), node.getStartMark(), node.getEndMark()));
        }
        validationResults.addAll(super.validateValue(node));
        this.setValueNode(node);
        return validationResults;
    }

    public boolean wasAlreadyDefined() {
        return this.keyNode != null;
    }

    public void setKeyNode(ScalarNode rulePresent) {
        this.keyNode = rulePresent;
    }

    public ScalarNode getKeyNode() {
        return this.keyNode;
    }

    public ScalarNode getValueNode() {
        return this.valueNode;
    }

    public void setValueNode(ScalarNode valueNode) {
        this.valueNode = valueNode;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public void setFieldClass(Class<?> fieldClass) {
        this.fieldClass = fieldClass;
    }
}

