/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.builder.AbastractFactory;
import org.raml.parser.resolver.DefaultTupleHandler;
import org.raml.parser.resolver.EnumHandler;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.rule.ContributionTupleRule;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.ImplicitMapEntryRule;
import org.raml.parser.rule.MapTupleRule;
import org.raml.parser.rule.MapWithListValueTupleRule;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.PojoTupleRule;
import org.raml.parser.rule.SequenceTupleRule;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRuleFactory
extends AbastractFactory {
    private NodeRuleFactoryExtension[] extensions;

    public NodeRuleFactory(NodeRuleFactoryExtension ... extensions) {
        this.extensions = extensions;
    }

    public DefaultTupleRule<Node, MappingNode> createDocumentRule(Class<?> documentClass) {
        DefaultTupleRule<Node, MappingNode> documentRule = new DefaultTupleRule<Node, MappingNode>(null, new DefaultTupleHandler());
        documentRule.setNodeRuleFactory(this);
        documentRule.addRulesFor(documentClass);
        return documentRule;
    }

    public void addRulesTo(Class<?> pojoClass, TupleRule<?, ?> parent) {
        List<Field> declaredFields = ReflectionUtils.getInheritedFields(pojoClass);
        HashMap innerBuilders = new HashMap();
        for (Field declaredField : declaredFields) {
            Scalar scalar = declaredField.getAnnotation(Scalar.class);
            Mapping mapping = declaredField.getAnnotation(Mapping.class);
            Sequence sequence = declaredField.getAnnotation(Sequence.class);
            TupleRule<?, ?> tupleRule = null;
            TupleHandler tupleHandler = null;
            boolean required = false;
            if (scalar != null) {
                tupleRule = this.createScalarRule(declaredField, scalar);
                tupleHandler = this.createHandler(scalar.handler(), scalar.alias(), ScalarNode.class);
                required = scalar.required();
            } else if (mapping != null) {
                tupleRule = this.createMappingRule(declaredField, mapping);
                tupleHandler = this.createHandler(mapping.handler(), mapping.alias(), MappingNode.class);
                required = mapping.required();
            } else if (sequence != null) {
                tupleRule = this.createSequenceRule(declaredField, sequence);
                tupleHandler = this.createHandler(sequence.handler(), sequence.alias(), SequenceNode.class);
                required = sequence.required();
            }
            if (tupleRule == null) continue;
            if (tupleHandler != null) {
                tupleRule.setHandler(tupleHandler);
            }
            tupleRule.setRequired(required);
            tupleRule.setParentTupleRule(parent);
            tupleRule.setNodeRuleFactory(this);
            innerBuilders.put(declaredField.getName(), tupleRule);
        }
        parent.setNestedRules(innerBuilders);
    }

    private TupleRule<?, ?> createSequenceRule(Field declaredField, Sequence sequence) {
        TupleRule tupleRule = null;
        if (sequence.rule() != TupleRule.class) {
            tupleRule = this.createInstanceOf(sequence.rule());
        } else if (List.class.isAssignableFrom(declaredField.getType())) {
            Type type = declaredField.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type itemType = pType.getActualTypeArguments()[0];
                tupleRule = new SequenceTupleRule(declaredField.getName(), itemType);
            }
        } else {
            throw new RuntimeException("Only List can be sequence. Error on field " + declaredField.getName());
        }
        return tupleRule;
    }

    private TupleRule<?, ?> createMappingRule(Field declaredField, Mapping mapping) {
        TupleRule tupleRule = null;
        if (mapping.rule() != TupleRule.class) {
            tupleRule = this.createInstanceOf(mapping.rule());
        } else if (Map.class.isAssignableFrom(declaredField.getType())) {
            Type type = declaredField.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type keyType = pType.getActualTypeArguments()[0];
                Type valueType = pType.getActualTypeArguments()[1];
                if (keyType instanceof Class) {
                    Type listType;
                    Type rawType;
                    Class keyClass = (Class)keyType;
                    if (valueType instanceof Class) {
                        tupleRule = mapping.implicit() ? new ImplicitMapEntryRule(declaredField.getName(), (Class)valueType) : new MapTupleRule(declaredField.getName(), (Class)valueType);
                        if (keyClass.isEnum()) {
                            tupleRule.setHandler(new EnumHandler(MappingNode.class, keyClass));
                        }
                    } else if (valueType instanceof ParameterizedType && (rawType = ((ParameterizedType)valueType).getRawType()) instanceof Class && List.class.isAssignableFrom((Class)rawType) && (listType = ((ParameterizedType)valueType).getActualTypeArguments()[0]) instanceof Class) {
                        tupleRule = new MapWithListValueTupleRule(declaredField.getName(), (Class)listType, this);
                    }
                }
            }
        } else {
            tupleRule = new PojoTupleRule(declaredField.getName(), declaredField.getType());
        }
        ArrayList<TupleRule> contributionRules = new ArrayList<TupleRule>();
        for (NodeRuleFactoryExtension extension : this.extensions) {
            if (!extension.handles(declaredField, mapping)) continue;
            TupleRule<?, ?> rule = extension.createRule(declaredField, mapping);
            contributionRules.add(rule);
        }
        if (!contributionRules.isEmpty()) {
            tupleRule = new ContributionTupleRule(tupleRule, contributionRules);
        }
        return tupleRule;
    }

    private TupleRule<?, ?> createScalarRule(Field declaredField, Scalar scalar) {
        TupleRule tupleRule = scalar.rule() != TupleRule.class ? this.createInstanceOf(scalar.rule()) : (ReflectionUtils.isPojo(declaredField.getType()) ? new PojoTupleRule(declaredField.getName(), declaredField.getType()) : new SimpleRule(declaredField.getName(), declaredField.getType()));
        return tupleRule;
    }
}

