/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.util.HashMap;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.PojoTupleBuilder;
import org.raml.parser.builder.ScalarTupleBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTupleBuilder
extends DefaultTupleBuilder<ScalarNode, Node> {
    private Class valueClass;
    private String fieldName;

    public MapTupleBuilder(Class<?> valueClass) {
        this(null, valueClass);
    }

    public MapTupleBuilder(String fieldName, Class<?> valueClass) {
        super(new DefaultScalarTupleHandler(MappingNode.class, fieldName));
        this.fieldName = fieldName;
        this.valueClass = valueClass;
    }

    @Override
    public TupleBuilder getBuilderForTuple(NodeTuple tuple) {
        if (ReflectionUtils.isPojo(this.getValueClass())) {
            return new PojoTupleBuilder(this.getValueClass());
        }
        return new ScalarTupleBuilder(null, this.getValueClass());
    }

    @Override
    public Object buildValue(Object parent, Node node) {
        HashMap map = new HashMap();
        ReflectionUtils.setProperty(parent, this.getFieldName(), map);
        return map;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.fieldName;
    }
}

