/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class MediaTypeResolver {
    private static Set<String> MEDIA_TYPE_KEYS;
    private String mediaType;

    public List<ValidationResult> beforeDocumentStart(MappingNode rootNode) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (rootNode == null) {
            validationResults.add(ValidationResult.createErrorResult("Invalid Root Node"));
            return validationResults;
        }
        for (NodeTuple tuple : rootNode.getValue()) {
            String key;
            if (tuple.getKeyNode().getNodeId() != NodeId.scalar || !(key = ((ScalarNode)tuple.getKeyNode()).getValue()).equals("mediaType")) continue;
            Node valueNode = tuple.getValueNode();
            if (valueNode.getNodeId() != NodeId.scalar) {
                validationResults.add(ValidationResult.createErrorResult("Invalid mediaType", valueNode.getStartMark(), valueNode.getEndMark()));
                break;
            }
            String value = ((ScalarNode)valueNode).getValue();
            if (!this.isValidMediaType(value)) {
                validationResults.add(ValidationResult.createErrorResult("Invalid mediaType", valueNode.getStartMark(), valueNode.getEndMark()));
                break;
            }
            this.mediaType = value;
            break;
        }
        return validationResults;
    }

    private boolean isValidMediaType(String value) {
        return value.matches(".+/.+");
    }

    public List<ValidationResult> resolve(MappingNode bodyNode) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (this.mediaType == null) {
            return validationResults;
        }
        for (NodeTuple tuple : bodyNode.getValue()) {
            if (MEDIA_TYPE_KEYS.contains(((ScalarNode)tuple.getKeyNode()).getValue())) continue;
            return validationResults;
        }
        ArrayList copy = new ArrayList(bodyNode.getValue());
        ScalarNode keyNode = new ScalarNode(Tag.STR, this.mediaType, null, null, null);
        MappingNode valueNode = new MappingNode(Tag.MAP, copy, Boolean.valueOf(false));
        bodyNode.getValue().clear();
        bodyNode.getValue().add(new NodeTuple((Node)keyNode, (Node)valueNode));
        return validationResults;
    }

    public void setBodyDefaultMediaType(Map<String, Resource> resourceMap) {
        for (Resource resource : resourceMap.values()) {
            Map<ActionType, Action> actionMap = resource.getActions();
            for (Action action : actionMap.values()) {
                if (action.getBody() != null && action.getBody().isEmpty()) {
                    action.getBody().put(this.mediaType, new MimeType(this.mediaType));
                }
                for (Response response : action.getResponses().values()) {
                    if (response.getBody() == null || !response.getBody().isEmpty()) continue;
                    response.getBody().put(this.mediaType, new MimeType(this.mediaType));
                }
            }
            this.setBodyDefaultMediaType(resource.getResources());
        }
    }

    static {
        String[] keys = new String[]{"schema", "example", "formParameters"};
        MEDIA_TYPE_KEYS = new HashSet<String>(Arrays.asList(keys));
    }
}

