/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.math.BigDecimal;
import org.raml.model.parameter.AbstractParam;

public enum ParamType {
    STRING{

        @Override
        public boolean validate(AbstractParam param, String value) {
            if (param.getPattern() != null && !value.matches(param.getPattern())) {
                return false;
            }
            if (param.getMinLength() != null && value.length() < param.getMinLength()) {
                return false;
            }
            if (param.getMaxLength() != null && value.length() > param.getMaxLength()) {
                return false;
            }
            return param.getEnumeration() == null || param.getEnumeration().contains(value);
        }
    }
    ,
    NUMBER{

        @Override
        public boolean validate(AbstractParam param, String value) {
            BigDecimal number;
            try {
                number = new BigDecimal(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (param.getMinimum() != null && number.compareTo(param.getMinimum()) < 0) {
                return false;
            }
            return param.getMaximum() == null || number.compareTo(param.getMaximum()) <= 0;
        }
    }
    ,
    INTEGER{

        @Override
        public boolean validate(AbstractParam param, String value) {
            Integer number;
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (param.getMinimum() != null && BigDecimal.valueOf(number.intValue()).compareTo(param.getMinimum()) < 0) {
                return false;
            }
            return param.getMaximum() == null || BigDecimal.valueOf(number.intValue()).compareTo(param.getMaximum()) <= 0;
        }
    }
    ,
    DATE,
    FILE,
    BOOLEAN{

        @Override
        public boolean validate(AbstractParam param, String value) {
            return "true".equals(value) || "false".equals(value);
        }
    };


    public boolean validate(AbstractParam param, String value) {
        return true;
    }
}

