/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.raml.parser.visitor.IncludeInfo;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResult {
    public static int UNKNOWN = -1;
    private Level level;
    private String message;
    private int line;
    private int startColumn;
    private int endColumn;
    private Deque<IncludeInfo> includeContext = new ArrayDeque<IncludeInfo>();

    private ValidationResult(Level level, String message, int line, int startColumn, int endColumn) {
        this.level = level;
        this.message = message;
        this.line = line;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public int getLine() {
        return this.line;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public boolean isValid() {
        return this.level != Level.ERROR;
    }

    public String getIncludeName() {
        if (this.includeContext.isEmpty()) {
            return null;
        }
        return this.includeContext.peek().getIncludeName();
    }

    public Deque<IncludeInfo> getIncludeContext() {
        return this.includeContext;
    }

    public void setIncludeContext(Deque<IncludeInfo> includeContext) {
        this.includeContext = new ArrayDeque<IncludeInfo>(includeContext);
    }

    public void addIncludeContext(Deque<IncludeInfo> includeContext) {
        this.includeContext.addAll(includeContext);
    }

    public static boolean areValid(List<ValidationResult> validationResults) {
        for (ValidationResult result : validationResults) {
            if (result.isValid()) continue;
            return false;
        }
        return true;
    }

    public static List<ValidationResult> getLevel(Level level, List<ValidationResult> results) {
        ArrayList<ValidationResult> filtered = new ArrayList<ValidationResult>();
        for (ValidationResult result : results) {
            if (result.level != level) continue;
            filtered.add(result);
        }
        return filtered;
    }

    public String toString() {
        return "ValidationResult{level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + '}';
    }

    public static ValidationResult createErrorResult(String message, int line, int startIndex, int endIndex) {
        return new ValidationResult(Level.ERROR, message, line, startIndex, endIndex);
    }

    public static ValidationResult createErrorResult(String message, Mark startMark, Mark endMark) {
        return ValidationResult.createErrorResult(message, startMark.getLine(), startMark.getColumn(), endMark.getColumn());
    }

    public static ValidationResult createErrorResult(String message, Node node) {
        return ValidationResult.createErrorResult(message, node.getStartMark(), node.getEndMark());
    }

    public static ValidationResult createErrorResult(String message) {
        return ValidationResult.createErrorResult(message, UNKNOWN, UNKNOWN, UNKNOWN);
    }

    public static ValidationResult create(Level level, String message) {
        return new ValidationResult(level, message, UNKNOWN, UNKNOWN, UNKNOWN);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        ERROR,
        WARN,
        INFO;

    }
}

