/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import org.raml.parser.tagresolver.ContextPath;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class IncludeInfo {
    private int line;
    private int startColumn;
    private int endColumn;
    private String includeName;

    public IncludeInfo(int line, int startColumn, int endColumn, String includeName) {
        this.line = line;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.includeName = includeName;
    }

    public IncludeInfo(Mark startMark, Mark endMark, String includeName) {
        this(startMark.getLine(), startMark.getColumn(), endMark.getColumn(), includeName);
    }

    public IncludeInfo(ScalarNode node, String parentPath) {
        this(node.getStartMark(), node.getEndMark(), ContextPath.resolveAbsolutePath(node.getValue(), parentPath));
    }

    public IncludeInfo(Tag tag) {
        StringBuilder encodedInclude = new StringBuilder(tag.getValue());
        this.endColumn = this.popTrailingNumber(encodedInclude);
        this.startColumn = this.popTrailingNumber(encodedInclude);
        this.line = this.popTrailingNumber(encodedInclude);
        this.includeName = encodedInclude.substring("!include-applied_".length());
    }

    public IncludeInfo(String name) {
        this.includeName = name;
    }

    private int popTrailingNumber(StringBuilder encodedInclude) {
        int idx = encodedInclude.lastIndexOf("_");
        int result = Integer.parseInt(encodedInclude.substring(idx + 1));
        encodedInclude.delete(idx, encodedInclude.length());
        return result;
    }

    public int getLine() {
        return this.line;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getIncludeName() {
        return this.includeName;
    }
}

