/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.tagresolver;

import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.JacksonTagResolver;
import org.raml.parser.tagresolver.JaxbTagResolver;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.NodeHandler;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class PojoValidatorTagResolver
implements TagResolver {
    @Override
    public boolean handles(Tag tag) {
        return JacksonTagResolver.JACKSON_TAG.equals((Object)tag) || JaxbTagResolver.JAXB_TAG.equals((Object)tag);
    }

    @Override
    public Node resolve(Node node, ResourceLoader resourceLoader, NodeHandler nodeHandler) {
        String className = ((ScalarNode)node).getValue();
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (NoClassDefFoundError e) {
            nodeHandler.onCustomTagError(node.getTag(), node, "Class not found " + className);
        }
        catch (ClassNotFoundException e) {
            nodeHandler.onCustomTagError(node.getTag(), node, "Class not found " + className);
        }
        return node;
    }

    @Override
    public void beforeProcessingResolvedNode(Tag tag, Node originalValueNode, Node resolvedNode) {
    }

    @Override
    public void afterProcessingResolvedNode(Tag tag, Node originalValueNode, Node resolvedNode) {
    }
}

