/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.math.BigDecimal;
import org.raml.model.parameter.AbstractParam;

public enum ParamType {
    STRING{

        @Override
        public String message(AbstractParam param, String value) {
            if (param.getPattern() != null && !value.matches(param.getPattern())) {
                return "Value does not match pattern " + param.getPattern();
            }
            if (param.getMinLength() != null && value.length() < param.getMinLength()) {
                return "Value length is shorter than " + param.getMinLength();
            }
            if (param.getMaxLength() != null && value.length() > param.getMaxLength()) {
                return "Value length is longer than " + param.getMaxLength();
            }
            if (param.getEnumeration() != null && !param.getEnumeration().contains(value)) {
                return "Value must be one of " + param.getEnumeration();
            }
            return ParamType.OK;
        }
    }
    ,
    NUMBER{

        @Override
        public String message(AbstractParam param, String value) {
            BigDecimal number;
            try {
                number = new BigDecimal(value);
            }
            catch (NumberFormatException nfe) {
                return "Number required";
            }
            if (param.getMinimum() != null && number.compareTo(param.getMinimum()) < 0) {
                return "Value is below the minimum " + param.getMinimum();
            }
            if (param.getMaximum() != null && number.compareTo(param.getMaximum()) > 0) {
                return "Value is above the maximum " + param.getMaximum();
            }
            return ParamType.OK;
        }
    }
    ,
    INTEGER{

        @Override
        public String message(AbstractParam param, String value) {
            Integer number;
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return "Integer required";
            }
            if (param.getMinimum() != null && BigDecimal.valueOf(number.intValue()).compareTo(param.getMinimum()) < 0) {
                return "Value is below the minimum " + param.getMinimum();
            }
            if (param.getMaximum() != null && BigDecimal.valueOf(number.intValue()).compareTo(param.getMaximum()) > 0) {
                return "Value is above the maximum " + param.getMaximum();
            }
            return ParamType.OK;
        }
    }
    ,
    DATE,
    FILE,
    BOOLEAN{

        @Override
        public String message(AbstractParam param, String value) {
            if ("true".equals(value) || "false".equals(value)) {
                return ParamType.OK;
            }
            return "Value must be one of [true, false]";
        }
    };

    public static final String OK = "OK";

    public boolean validate(AbstractParam param, String value) {
        return OK.equals(this.message(param, value));
    }

    public String message(AbstractParam param, String value) {
        return OK;
    }
}

