/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.ValidationMessage;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.utils.ConvertUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRule
extends DefaultTupleRule<ScalarNode, ScalarNode> {
    private ScalarNode keyNode;
    private ScalarNode valueNode;
    private Class<?> fieldClass;

    public SimpleRule(String fieldName, Class<?> fieldClass) {
        super(fieldName, new DefaultScalarTupleHandler(fieldName));
        this.setFieldClass(fieldClass);
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        List<ValidationResult> validationResults = super.validateKey(key);
        if (this.wasAlreadyDefined()) {
            validationResults.add(ValidationResult.createErrorResult(ValidationMessage.getDuplicateRuleMessage(this.getName()), (Node)key));
        }
        this.setKeyNode(key);
        return validationResults;
    }

    @Override
    public List<ValidationResult> doValidateValue(ScalarNode node) {
        String value = node.getValue();
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (StringUtils.isEmpty((String)value)) {
            validationResults.add(ValidationResult.createErrorResult(ValidationMessage.getRuleEmptyMessage(this.getName()), (Node)this.keyNode));
        }
        if (!ConvertUtils.canBeConverted(value, this.getFieldClass())) {
            validationResults.add(ValidationResult.createErrorResult(ValidationMessage.getRuleTypeMisMatch(this.getName(), this.getFieldClass().getSimpleName()), (Node)node));
        }
        this.setValueNode(node);
        return validationResults;
    }

    @Override
    public Class<?>[] getValueType() {
        return new Class[]{ScalarNode.class};
    }

    public boolean wasAlreadyDefined() {
        return this.keyNode != null;
    }

    public void setKeyNode(ScalarNode rulePresent) {
        this.keyNode = rulePresent;
    }

    public ScalarNode getKeyNode() {
        return this.keyNode;
    }

    public ScalarNode getValueNode() {
        return this.valueNode;
    }

    public void setValueNode(ScalarNode valueNode) {
        this.valueNode = valueNode;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public void setFieldClass(Class<?> fieldClass) {
        this.fieldClass = fieldClass;
    }
}

