/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.eel.kitchen.jsonschema.util.JsonLoader;
import org.raml.parser.rule.GlobalSchemasRule;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.IncludeResolver;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaRule
extends SimpleRule {
    public SchemaRule() {
        super("schema", String.class);
    }

    @Override
    public List<ValidationResult> doValidateValue(ScalarNode node) {
        String value = node.getValue();
        List<ValidationResult> validationResults = super.doValidateValue(node);
        String mimeType = ((ScalarNode)this.getParentTupleRule().getKey()).getValue();
        if (mimeType.contains("json") && Tag.STR.equals((Object)node.getTag())) {
            try {
                value = this.getGlobalSchemaIfDefined(value);
                if (value != null) {
                    JsonLoader.fromString((String)value);
                }
            }
            catch (IOException e) {
                String prefix = "invalid JSON schema" + this.getSourceErrorDetail(node);
                validationResults.add(ValidationResult.createErrorResult(prefix + e.getMessage(), node.getStartMark(), node.getEndMark()));
            }
        } else if (mimeType.contains("xml") && Tag.STR.equals((Object)node.getTag())) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                value = this.getGlobalSchemaIfDefined(value);
                if (value != null) {
                    factory.newSchema(new StreamSource(new StringReader(value)));
                }
            }
            catch (SAXException e) {
                String prefix = "invalid XML schema" + this.getSourceErrorDetail(node);
                validationResults.add(ValidationResult.createErrorResult(prefix + e.getMessage(), node.getStartMark(), node.getEndMark()));
            }
        }
        return validationResults;
    }

    private String getSourceErrorDetail(ScalarNode node) {
        String msg = "";
        if (node instanceof IncludeResolver.IncludeScalarNode) {
            msg = " (" + ((IncludeResolver.IncludeScalarNode)node).getIncludeName() + ")";
        } else if (node.getValue().matches("\\w.*")) {
            msg = " (" + node.getValue() + ")";
        }
        return msg + ": ";
    }

    private String getGlobalSchemaIfDefined(String key) {
        GlobalSchemasRule schemasRule = (GlobalSchemasRule)this.getRootTupleRule().getRuleByFieldName("schemas");
        Tag tag = schemasRule.getTags().get(key);
        if (this.isCustomTag(tag)) {
            return null;
        }
        String globalSchema = schemasRule.getSchemas().get(key);
        return globalSchema != null ? globalSchema : key;
    }

    private boolean isCustomTag(Tag tag) {
        return tag != null && !Tag.STR.equals((Object)tag);
    }
}

