/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationMessage;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitMapEntryRule
extends DefaultTupleRule<ScalarNode, MappingNode> {
    private final Class valueType;
    private final Set<String> keys = new HashSet<String>();

    public ImplicitMapEntryRule(String fieldName, Class valueType) {
        super(fieldName, new DefaultScalarTupleHandler(fieldName));
        this.valueType = valueType;
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        if (this.rules.isEmpty()) {
            this.addRulesFor(this.valueType);
        }
        return super.getRuleForTuple(nodeTuple);
    }

    @Override
    public List<ValidationResult> onRuleEnd() {
        List<ValidationResult> validationResults = super.onRuleEnd();
        this.rules.clear();
        return validationResults;
    }

    @Override
    public Class<?>[] getValueType() {
        return new Class[]{MappingNode.class};
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        List<ValidationResult> validationResults = super.validateKey(key);
        if (this.keys.contains(key.getValue())) {
            validationResults.add(ValidationResult.createErrorResult(ValidationMessage.getDuplicateRuleMessage(this.getName()), (Node)key));
        } else {
            this.keys.add(key.getValue());
        }
        return validationResults;
    }
}

