/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.TupleType;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class NodeVisitor {
    public static final String INCLUDE_TAG = "tag:raml.org,0.1:include";
    private NodeHandler nodeHandler;
    private ResourceLoader resourceLoader;

    public NodeVisitor(NodeHandler nodeHandler, ResourceLoader resourceLoader) {
        this.nodeHandler = nodeHandler;
        this.resourceLoader = resourceLoader;
    }

    private void visitMappingNode(MappingNode mappingNode, TupleType tupleType) {
        this.nodeHandler.onMappingNodeStart(mappingNode);
        this.doVisitMappingNode(mappingNode);
        this.nodeHandler.onMappingNodeEnd(mappingNode);
    }

    private void doVisitMappingNode(MappingNode mappingNode) {
        List<NodeTuple> tuples = mappingNode.getValue();
        ArrayList<NodeTuple> updatedTuples = new ArrayList<NodeTuple>();
        for (NodeTuple nodeTuple : tuples) {
            Node keyNode = nodeTuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode)) {
                throw new YAMLException("Only scalar keys are allowed: " + keyNode.getStartMark());
            }
            Node valueNode = nodeTuple.getValueNode();
            if (valueNode.getTag().startsWith(INCLUDE_TAG)) {
                valueNode = this.resolveInclude((ScalarNode)valueNode);
                nodeTuple = new NodeTuple(keyNode, valueNode);
            }
            updatedTuples.add(nodeTuple);
            this.nodeHandler.onTupleStart(nodeTuple);
            this.visit(keyNode, TupleType.KEY);
            this.visit(valueNode, TupleType.VALUE);
            this.nodeHandler.onTupleEnd(nodeTuple);
        }
        mappingNode.setValue(updatedTuples);
    }

    public void visitDocument(MappingNode node) {
        this.nodeHandler.onDocumentStart(node);
        if (node instanceof MappingNode) {
            this.doVisitMappingNode(node);
        }
        this.nodeHandler.onDocumentEnd(node);
    }

    private void visit(Node node, TupleType tupleType) {
        if (node.getNodeId() == NodeId.mapping) {
            this.visitMappingNode((MappingNode)node, tupleType);
        } else if (node.getNodeId() == NodeId.scalar) {
            this.visitScalar((ScalarNode)node, tupleType);
        } else if (node.getNodeId() == NodeId.sequence) {
            this.visitSequence((SequenceNode)node, tupleType);
        }
    }

    private void visitSequence(SequenceNode node, TupleType tupleType) {
        this.nodeHandler.onSequenceStart(node, tupleType);
        List<Node> value = node.getValue();
        for (Node sequenceNode : value) {
            this.nodeHandler.onSequenceElementStart(sequenceNode);
            this.visit(sequenceNode, tupleType);
            this.nodeHandler.onSequenceElementEnd(sequenceNode);
        }
        this.nodeHandler.onSequenceEnd(node, tupleType);
    }

    private void visitScalar(ScalarNode node, TupleType tupleType) {
        this.nodeHandler.onScalar(node, tupleType);
    }

    private Node resolveInclude(ScalarNode node) {
        Node includeNode;
        InputStream inputStream = null;
        try {
            String resourceName = node.getValue();
            inputStream = this.resourceLoader.fetchResource(resourceName);
            if (inputStream == null) {
                this.nodeHandler.onIncludeResourceNotFound(node);
                includeNode = new ScalarNode(Tag.STR, resourceName, node.getStartMark(), node.getEndMark(), node.getStyle());
            } else if (resourceName.endsWith(".yaml") || resourceName.endsWith(".yml")) {
                Yaml yamlParser = new Yaml();
                includeNode = yamlParser.compose(new InputStreamReader(inputStream));
            } else {
                String newValue = IOUtils.toString((InputStream)inputStream);
                includeNode = new ScalarNode(Tag.STR, newValue, node.getStartMark(), node.getEndMark(), node.getStyle());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return includeNode;
    }
}

