/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.TupleRuleFactory;
import org.raml.parser.rule.UnknownTupleRule;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTupleRule<K extends Node, V extends Node>
implements TupleRule<K, V> {
    private static final String IS_MISSING = "is missing";
    protected Map<String, TupleRule<?, ?>> rules;
    private TupleRule<?, ?> parent;
    private TupleHandler tupleHandler;
    private boolean required;
    private K key;
    private String fieldName;

    public DefaultTupleRule(String fieldName, TupleHandler handler) {
        this.fieldName = fieldName;
        this.rules = new HashMap();
        this.tupleHandler = handler;
    }

    public static String getMissingRuleMessage(String ruleName) {
        return ruleName + " " + IS_MISSING;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void setNestedRules(Map<String, TupleRule<?, ?>> rules) {
        this.rules = rules;
    }

    @Override
    public void setHandler(TupleHandler tupleHandler) {
        this.tupleHandler = tupleHandler;
    }

    @Override
    public TupleHandler getHandler() {
        return this.tupleHandler;
    }

    @Override
    public List<ValidationResult> validateKey(K key) {
        this.key = key;
        return new ArrayList<ValidationResult>(Arrays.asList(ValidationResult.okResult()));
    }

    @Override
    public List<ValidationResult> validateValue(V key) {
        return new ArrayList<ValidationResult>(Arrays.asList(ValidationResult.okResult()));
    }

    @Override
    public List<ValidationResult> onRuleEnd() {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        if (this.isRequired() && !this.wasAlreadyDefined()) {
            result.add(ValidationResult.createErrorResult(DefaultTupleRule.getMissingRuleMessage(this.fieldName)));
        }
        for (TupleRule<?, ?> rule : this.rules.values()) {
            List<ValidationResult> onRuleEnd = rule.onRuleEnd();
            result.addAll(onRuleEnd);
        }
        return result;
    }

    private boolean wasAlreadyDefined() {
        return this.key != null;
    }

    public K getKey() {
        return this.key;
    }

    public void addRulesFor(Class<?> pojoClass) {
        new TupleRuleFactory().addRulesTo(pojoClass, this);
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        for (TupleRule<?, ?> rule : this.rules.values()) {
            if (!rule.getHandler().handles(nodeTuple)) continue;
            return rule;
        }
        return new UnknownTupleRule(nodeTuple.getKeyNode().toString());
    }

    @Override
    public void setParentTupleRule(TupleRule<?, ?> parent) {
        this.parent = parent;
    }

    @Override
    public TupleRule<?, ?> getRuleByFieldName(String fieldName) {
        return this.rules.get(fieldName);
    }

    public TupleRule<?, ?> getParent() {
        return this.parent;
    }
}

