/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.builder.AbastractFactory;
import org.raml.parser.builder.ImplicitMapEntryBuilder;
import org.raml.parser.builder.MapTupleBuilder;
import org.raml.parser.builder.PojoTupleBuilder;
import org.raml.parser.builder.ScalarTupleBuilder;
import org.raml.parser.builder.SequenceTupleBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.resolver.EnumHandler;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleBuilderFactory
extends AbastractFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void addBuildersTo(Class<?> pojoClass, TupleBuilder parent) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("adding builders for " + pojoClass);
        }
        List<Field> declaredFields = ReflectionUtils.getInheritedFields(pojoClass);
        HashMap innerBuilders = new HashMap();
        for (Field declaredField : declaredFields) {
            Scalar scalar = declaredField.getAnnotation(Scalar.class);
            Mapping mapping = declaredField.getAnnotation(Mapping.class);
            Sequence sequence = declaredField.getAnnotation(Sequence.class);
            TupleBuilder<?, ?> tupleBuilder = null;
            TupleHandler tupleHandler = null;
            if (scalar != null) {
                tupleBuilder = this.createScalarBuilder(declaredField, scalar);
                tupleHandler = this.createHandler(scalar.handler(), scalar.alias(), ScalarNode.class);
            } else if (mapping != null) {
                tupleBuilder = this.createMappingBuilder(declaredField, mapping);
                tupleHandler = this.createHandler(mapping.handler(), mapping.alias(), MappingNode.class);
            } else if (sequence != null) {
                tupleBuilder = this.createSequenceBuilder(declaredField, sequence);
                tupleHandler = this.createHandler(sequence.handler(), sequence.alias(), SequenceNode.class);
            }
            if (tupleBuilder == null) continue;
            if (tupleHandler != null) {
                tupleBuilder.setHandler(tupleHandler);
            }
            tupleBuilder.setParentNodeBuilder(parent);
            innerBuilders.put(declaredField.getName(), tupleBuilder);
        }
        parent.setNestedBuilders(innerBuilders);
    }

    private TupleBuilder<?, ?> createSequenceBuilder(Field declaredField, Sequence sequence) {
        TupleBuilder tupleBuilder = null;
        if (sequence.builder() != TupleBuilder.class) {
            tupleBuilder = this.createInstanceOf(sequence.builder());
        } else if (List.class.isAssignableFrom(declaredField.getType())) {
            ParameterizedType pType;
            Type itemType;
            Type type = declaredField.getGenericType();
            if (type instanceof ParameterizedType && (itemType = (pType = (ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                tupleBuilder = new SequenceTupleBuilder(declaredField.getName(), (Class)itemType);
            }
        } else {
            throw new RuntimeException("Only List can be sequence. Error on field " + declaredField.getName());
        }
        return tupleBuilder;
    }

    private TupleBuilder<?, ?> createScalarBuilder(Field declaredField, Scalar scalar) {
        TupleBuilder tupleBuilder = scalar.builder() != TupleBuilder.class ? this.createInstanceOf(scalar.builder()) : new ScalarTupleBuilder(declaredField.getName(), declaredField.getType());
        return tupleBuilder;
    }

    private TupleBuilder<?, ?> createMappingBuilder(Field declaredField, Mapping mapping) {
        TupleBuilder tupleBuilder = null;
        if (mapping.builder() != TupleBuilder.class) {
            tupleBuilder = this.createInstanceOf(mapping.builder());
        } else if (Map.class.isAssignableFrom(declaredField.getType())) {
            Type type = declaredField.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type keyType = pType.getActualTypeArguments()[0];
                Type valueType = pType.getActualTypeArguments()[1];
                if (keyType instanceof Class && valueType instanceof Class) {
                    Class keyClass = (Class)keyType;
                    tupleBuilder = mapping.implicit() ? new ImplicitMapEntryBuilder(declaredField.getName(), keyClass, (Class)valueType) : new MapTupleBuilder(declaredField.getName(), keyClass, (Class)valueType);
                    if (keyClass.isEnum()) {
                        tupleBuilder.setHandler(new EnumHandler(MappingNode.class, keyClass));
                    }
                }
            }
        } else {
            tupleBuilder = new PojoTupleBuilder(declaredField.getName(), declaredField.getDeclaringClass());
        }
        return tupleBuilder;
    }
}

