/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model.validation;

import org.raml.model.validation.Validation;

public class MinimumIntegerValidation
implements Validation {
    private Integer minimum;

    public MinimumIntegerValidation(String minimum) {
        this.minimum = this.parse(minimum);
    }

    public Integer parse(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse number: " + value);
        }
    }

    public boolean check(String input) {
        return this.minimum.compareTo(this.parse(input)) <= 0;
    }
}

