/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.util.HashMap;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;
import org.raml.parser.annotation.Key;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitAction {
    @Key
    private String type;
    @Scalar
    private String summary;
    @Scalar
    private String description;
    @Mapping
    private Map<String, Header> headers = new HashMap<String, Header>();
    @Mapping
    private Map<String, QueryParameter> queryParameters = new HashMap<String, QueryParameter>();
    @Mapping
    private Map<String, MimeType> body = new HashMap<String, MimeType>();
    @Mapping
    private Map<String, Response> responses = new HashMap<String, Response>();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Header> headers) {
        this.headers = headers;
    }

    public Map<String, QueryParameter> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, QueryParameter> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Map<String, MimeType> getBody() {
        return this.body;
    }

    public void setBody(Map<String, MimeType> body) {
        this.body = body;
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, Response> responses) {
        this.responses = responses;
    }

    public String toString() {
        return "Action{type='" + this.type + '}';
    }

    public Action createAction(Resource resource) {
        Action action = new Action();
        action.setType(ActionType.valueOf(this.type.toUpperCase()));
        action.setDescription(this.description);
        action.setHeaders(this.headers);
        action.setQueryParameters(this.queryParameters);
        action.setBody(this.body);
        action.setResponses(this.responses);
        action.setResource(resource);
        return action;
    }

    public void updateAction(Action action) {
        if (action.getDescription() == null) {
            action.setDescription(this.description);
        }
        for (String key : this.headers.keySet()) {
            if (action.getHeaders().get(key) != null) continue;
            action.getHeaders().put(key, this.headers.get(key));
        }
        for (String key : this.queryParameters.keySet()) {
            if (action.getQueryParameters().get(key) != null) continue;
            action.getQueryParameters().put(key, this.queryParameters.get(key));
        }
        for (String key : this.body.keySet()) {
            if (action.getBody().get(key) != null) continue;
            action.getBody().put(key, this.body.get(key));
        }
        for (String key : this.responses.keySet()) {
            if (action.getResponses().get(key) != null) continue;
            action.getResponses().put(key, this.responses.get(key));
        }
    }
}

