/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model.type;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.ws.commons.schema.XmlSchema;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.model.Annotable;
import org.raml.v2.internal.impl.commons.model.RamlValidationResult;
import org.raml.v2.internal.impl.commons.model.factory.TypeDeclarationModelFactory;
import org.raml.v2.internal.impl.commons.nodes.ExternalSchemaTypeExpressionNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.SchemaBasedResolvedType;
import org.raml.v2.internal.impl.v10.nodes.NamedTypeExpressionNode;
import org.raml.v2.internal.impl.v10.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.phase.ExampleValidationPhase;
import org.raml.v2.internal.impl.v10.type.AnyResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeToSchemaVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.v2.internal.utils.RamlNodeUtils;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.util.NodeSelector;

public abstract class TypeDeclaration<T extends ResolvedType>
extends Annotable {
    private static final List<String> GLOBAL_NAMED_TYPE_DECLARATION_NODE_NAMES = Arrays.asList("types", "annotationTypes", "baseUriParameters");
    private static final List<String> LOCAL_NAMED_TYPE_DECLARATION_NODE_NAMES = Arrays.asList("headers", "queryParameters", "queryString", "uriParameters");
    private KeyValueNode node;
    private T resolvedType;

    public TypeDeclaration(KeyValueNode node, T resolvedType) {
        this.node = node;
        this.resolvedType = resolvedType;
    }

    public T getResolvedType() {
        return this.resolvedType;
    }

    public Node getNode() {
        return this.node.getValue();
    }

    public String name() {
        if (this.node instanceof PropertyNode) {
            return ((PropertyNode)this.node).getName();
        }
        String keyValue = ((StringNode)this.node.getKey()).getValue();
        Node parentTypeNode = this.node.getValue();
        if (this.node.getParent() instanceof TypeDeclarationNode && parentTypeNode instanceof TypeExpressionNode) {
            if (parentTypeNode instanceof ExternalSchemaTypeExpressionNode) {
                return null;
            }
            return ((TypeExpressionNode)parentTypeNode).getTypeExpressionText();
        }
        return keyValue;
    }

    @Nullable
    public String type() {
        Node typeNode = this.getTypeNode();
        return typeNode != null ? this.getTypeExpression(typeNode) : null;
    }

    private String getTypeExpression(Node typeNode) {
        if (typeNode instanceof TypeExpressionNode) {
            return ((TypeExpressionNode)typeNode).getTypeExpressionText();
        }
        if (typeNode.getSource() instanceof StringNode) {
            return ((StringNode)typeNode.getSource()).getValue();
        }
        return null;
    }

    public List<TypeDeclaration<?>> parentTypes() {
        ResolvedType type;
        ArrayList result = new ArrayList();
        Node typeNode = this.getTypeNode();
        if (typeNode instanceof ArrayNode) {
            List children = typeNode.getChildren();
            for (Node child : children) {
                result.add(this.toTypeDeclaration(((NamedTypeExpressionNode)child).getRefNode()));
            }
        } else if (typeNode instanceof TypeExpressionNode && (type = ((TypeExpressionNode)typeNode).generateDefinition()) != null) {
            result.add(this.toTypeDeclaration(type));
        }
        return result;
    }

    private TypeDeclaration<?> toTypeDeclaration(ResolvedType type) {
        return new TypeDeclarationModelFactory().create(type);
    }

    private TypeDeclaration<?> toTypeDeclaration(Node typeNode) {
        return new TypeDeclarationModelFactory().create(typeNode);
    }

    public String schemaContent() {
        ResolvedType resolvedType;
        TypeDeclarationNode value;
        List<TypeExpressionNode> baseTypes;
        if (this.node.getValue() instanceof TypeDeclarationNode && !(baseTypes = (value = (TypeDeclarationNode)this.node.getValue()).getBaseTypes()).isEmpty() && (resolvedType = baseTypes.get(0).generateDefinition()) instanceof SchemaBasedResolvedType) {
            return ((SchemaBasedResolvedType)resolvedType).getSchemaValue();
        }
        return null;
    }

    public List<RamlValidationResult> validate(String payload) {
        TypeDeclarationNode node = (TypeDeclarationNode)this.getNode();
        ResourceLoader resourceLoader = node.getStartPosition().getResourceLoader();
        ExampleValidationPhase exampleValidationPhase = new ExampleValidationPhase(resourceLoader);
        Node validate = exampleValidationPhase.validate(node, payload);
        if (validate instanceof ErrorNode) {
            return Collections.singletonList(new RamlValidationResult((ErrorNode)validate));
        }
        return Collections.emptyList();
    }

    public Boolean required() {
        if (this.node instanceof PropertyNode) {
            return ((PropertyNode)this.node).isRequired();
        }
        if (RamlNodeUtils.getVersion(this.getNode()) == RamlVersion.RAML_10 || this.isUriParameter(this.getNode())) {
            return (Boolean)NodeSelector.selectType((String)"required", (Node)this.getNode(), (Object)true);
        }
        return (Boolean)NodeSelector.selectType((String)"required", (Node)this.getNode(), (Object)false);
    }

    private boolean isUriParameter(Node node) {
        Node ancestor = NodeSelector.selectFrom((String)"../../../../uriParameters", (Node)node);
        return ancestor != null;
    }

    public String defaultValue() {
        Object defaultValue = NodeSelector.selectType((String)"default", (Node)this.getNode(), null);
        return defaultValue != null ? defaultValue.toString() : null;
    }

    public String toXmlSchema() {
        if (this.getResolvedType() instanceof SchemaBasedResolvedType || this.getResolvedType() instanceof AnyResolvedType || this.getResolvedType() == null) {
            return null;
        }
        TypeToSchemaVisitor typeToSchemaVisitor = new TypeToSchemaVisitor();
        typeToSchemaVisitor.transform(this.rootElementName(), (ResolvedType)this.getResolvedType());
        XmlSchema schema = typeToSchemaVisitor.getSchema();
        StringWriter writer = new StringWriter();
        schema.write((Writer)writer);
        return writer.toString();
    }

    public String rootElementName() {
        String xmlName;
        if (this.resolvedType instanceof XmlFacetsCapableType && (xmlName = ((XmlFacetsCapableType)this.resolvedType).getXmlFacets().getName()) != null) {
            return xmlName;
        }
        if (!(this.node instanceof PropertyNode || this.isGlobalNamedTypeDeclarationNode() || this.isLocalNamedTypeDeclarationNode())) {
            Node value = this.node.getValue();
            if (value.get("properties") != null || value.get("facets") != null || !(this.getTypeNode() instanceof NamedTypeExpressionNode)) {
                return "root";
            }
            return ((NamedTypeExpressionNode)this.getTypeNode()).getRefName();
        }
        return this.name();
    }

    @Nullable
    private Node getTypeNode() {
        Node value = this.node.getValue();
        Node type = value.get("type");
        if (type != null) {
            return type;
        }
        return value.get("schema");
    }

    private boolean isGlobalNamedTypeDeclarationNode() {
        final Node parent = this.node.getParent();
        final Node rootNode = this.node.getRootNode();
        return Iterables.any(GLOBAL_NAMED_TYPE_DECLARATION_NODE_NAMES, (Predicate)new Predicate<String>(){

            public boolean apply(String name) {
                return parent == rootNode.get(name);
            }
        });
    }

    private boolean isLocalNamedTypeDeclarationNode() {
        final Node parent = this.node.getParent();
        final Node baseNode = parent.getParent().getParent();
        return baseNode != null && Iterables.any(LOCAL_NAMED_TYPE_DECLARATION_NODE_NAMES, (Predicate)new Predicate<String>(){

            public boolean apply(String name) {
                return parent == baseNode.get(name);
            }
        });
    }
}

