/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.nodes.BodyNode;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.yagi.framework.nodes.BaseNode;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.Position;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.util.NodeSelector;

public class MediaTypeInjectionPhase
implements Phase {
    public Node apply(Node tree) {
        List<StringNode> defaultMediaTypes = this.getDefaultMediaTypes(tree);
        if (!defaultMediaTypes.isEmpty()) {
            List bodyNodes = tree.findDescendantsWith(BodyNode.class);
            for (BodyNode bodyNode : bodyNodes) {
                if (this.hasExplicitMimeTypes(bodyNode)) continue;
                this.injectMediaTypes(bodyNode, defaultMediaTypes);
            }
        }
        return tree;
    }

    private List<StringNode> getDefaultMediaTypes(Node tree) {
        ArrayList<StringNode> result = new ArrayList<StringNode>();
        Node mediaTypeNode = NodeSelector.selectFrom((String)"mediaType", (Node)tree);
        if (mediaTypeNode != null) {
            if (mediaTypeNode instanceof StringNode) {
                result.add((StringNode)mediaTypeNode);
            } else {
                for (Node node : mediaTypeNode.getChildren()) {
                    result.add((StringNode)node);
                }
            }
        }
        return result;
    }

    private void injectMediaTypes(BodyNode bodyNode, List<StringNode> defaultMediaTypes) {
        MediaTypeInjectedNode injected = new MediaTypeInjectedNode();
        for (StringNode defaultMediaType : defaultMediaTypes) {
            Node copy = bodyNode.getValue().copy();
            KeyValueNodeImpl keyValue = new KeyValueNodeImpl(defaultMediaType.copy(), copy);
            injected.addChild((Node)keyValue);
        }
        bodyNode.setValue((Node)injected);
    }

    private boolean hasExplicitMimeTypes(BodyNode bodyNode) {
        List children = bodyNode.getValue().getChildren();
        if (!children.isEmpty() && !((Node)children.get(0)).getChildren().isEmpty()) {
            Node key = (Node)((Node)children.get(0)).getChildren().get(0);
            return new Raml10Grammar().mimeTypeRegex().matches(key);
        }
        return false;
    }

    private static class MediaTypeInjectedNode
    extends BaseNode
    implements ObjectNode {
        public MediaTypeInjectedNode() {
        }

        public MediaTypeInjectedNode(MediaTypeInjectedNode mediaTypeInjectedNode) {
            super((BaseNode)mediaTypeInjectedNode);
        }

        @Nonnull
        public Position getStartPosition() {
            return this.getParent() != null ? this.getParent().getStartPosition() : DefaultPosition.emptyPosition();
        }

        @Nonnull
        public Position getEndPosition() {
            return this.getChildren().isEmpty() ? DefaultPosition.emptyPosition() : ((Node)this.getChildren().get(0)).getEndPosition();
        }

        @Nonnull
        public Node copy() {
            return new MediaTypeInjectedNode(this);
        }

        public NodeType getType() {
            return NodeType.Object;
        }
    }
}

