/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.internal.impl.RamlBuilder;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.nodes.RamlVersionAnnotation;
import org.raml.v2.internal.impl.commons.phase.DuplicatedPathsTransformer;
import org.raml.v2.internal.impl.commons.phase.ExtensionsMerger;
import org.raml.v2.internal.impl.commons.phase.IncludeResolver;
import org.raml.v2.internal.impl.commons.phase.RamlFragmentGrammarTransformer;
import org.raml.v2.internal.impl.commons.phase.RamlFragmentLibraryLinkingTransformer;
import org.raml.v2.internal.impl.commons.phase.ResourceTypesTraitsTransformer;
import org.raml.v2.internal.impl.commons.phase.SchemaValidationTransformer;
import org.raml.v2.internal.impl.commons.phase.StringTemplateExpressionTransformer;
import org.raml.v2.internal.impl.commons.phase.TypeValidationPhase;
import org.raml.v2.internal.impl.commons.phase.UnusedParametersTransformer;
import org.raml.v2.internal.impl.v10.grammar.Raml10GrammarUsesAllowed;
import org.raml.v2.internal.impl.v10.phase.AnnotationValidationPhase;
import org.raml.v2.internal.impl.v10.phase.ExampleValidationPhase;
import org.raml.v2.internal.impl.v10.phase.ImplicitUriParametersInjectionTransformer;
import org.raml.v2.internal.impl.v10.phase.LibraryLinkingTransformation;
import org.raml.v2.internal.impl.v10.phase.MediaTypeInjectionPhase;
import org.raml.v2.internal.impl.v10.phase.ReferenceResolverTransformer;
import org.raml.v2.internal.utils.RamlNodeUtils;
import org.raml.v2.internal.utils.RamlTreeNodeDumper;
import org.raml.v2.internal.utils.ResourcePathUtils;
import org.raml.v2.internal.utils.StreamUtils;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.EmptyErrorNode;
import org.raml.yagi.framework.nodes.IncludeErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeAnnotation;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.nodes.snakeyaml.NodeParser;
import org.raml.yagi.framework.phase.GrammarPhase;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.phase.TransformationPhase;
import org.raml.yagi.framework.phase.Transformer;

public class Raml10Builder {
    private final Set<String> openedFiles = new HashSet<String>();
    private final Map<String, Node> alreadyBuilt = new HashMap<String, Node>();

    public Node build(String stringContent, RamlFragment fragment, ResourceLoader resourceLoader, String resourceLocation, int maxPhaseNumber) throws IOException {
        return this.build(null, stringContent, fragment, resourceLoader, resourceLocation, maxPhaseNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node build(Node contextNode, String stringContent, RamlFragment fragment, ResourceLoader resourceLoader, String resourceLocation, int maxPhaseNumber) throws IOException {
        String key = resourceLocation + String.valueOf(stringContent.hashCode());
        if (this.alreadyBuilt.containsKey(key)) {
            return this.alreadyBuilt.get(key);
        }
        if (this.openedFiles.contains(resourceLocation)) {
            return new IncludeErrorNode("Cyclic dependency loading file: " + resourceLocation);
        }
        try {
            this.openedFiles.add(resourceLocation);
            Node rootNode = NodeParser.parse((ResourceLoader)resourceLoader, (String)resourceLocation, (String)stringContent);
            if (rootNode == null) {
                EmptyErrorNode emptyErrorNode = ErrorNodeFactory.createEmptyDocument();
                return emptyErrorNode;
            }
            if (contextNode != null) {
                rootNode.setContextNode(contextNode);
            }
            boolean applyExtension = false;
            if ((fragment == RamlFragment.Extension || fragment == RamlFragment.Overlay) && maxPhaseNumber > RamlBuilder.FIRST_PHASE) {
                applyExtension = true;
                maxPhaseNumber = RamlBuilder.LIBRARY_LINK_PHASE;
            }
            List<Phase> phases = this.createPhases(resourceLoader, fragment);
            rootNode = this.runPhases(rootNode, phases, maxPhaseNumber);
            if (applyExtension && !RamlNodeUtils.isErrorResult(rootNode)) {
                rootNode = this.applyExtension(rootNode, resourceLoader, resourceLocation, fragment);
            }
            rootNode.annotate((NodeAnnotation)new RamlVersionAnnotation(RamlVersion.RAML_10));
            this.alreadyBuilt.put(key, rootNode);
            Node node = rootNode;
            return node;
        }
        finally {
            this.openedFiles.remove(resourceLocation);
        }
    }

    private Node runPhases(Node rootNode, List<Phase> phases, int maxPhaseNumber) {
        for (int i = 0; i < phases.size(); ++i) {
            if (i >= maxPhaseNumber) continue;
            Phase phase = phases.get(i);
            rootNode = phase.apply(rootNode);
            this.checkDumpPhases(i, phase, rootNode);
            if (RamlNodeUtils.isErrorResult(rootNode)) break;
        }
        return rootNode;
    }

    private void checkDumpPhases(int i, Phase phase, Node rootNode) {
        if (Boolean.getBoolean("dump.phases")) {
            String dump = new RamlTreeNodeDumper().dump(rootNode);
            System.out.println("===============================================================");
            System.out.println("After phase = " + i + " --- " + phase.getClass());
            System.out.println("---------------------------------------------------------------");
            System.out.println(dump);
            System.out.println("---------------------------------------------------------------");
        }
    }

    private Node applyExtension(Node extensionNode, ResourceLoader resourceLoader, String resourceLocation, RamlFragment fragment) throws IOException {
        StringNode baseRef = (StringNode)extensionNode.get("extends");
        String baseLocation = ResourcePathUtils.toAbsoluteLocation(resourceLocation, baseRef.getValue());
        InputStream baseStream = resourceLoader.fetchResource(baseLocation);
        if (baseStream == null) {
            return ErrorNodeFactory.createBaseRamlNotFound((String)baseRef.getValue());
        }
        String baseContent = StreamUtils.toString(baseStream);
        Node baseNode = new RamlBuilder().build(baseContent, resourceLoader, baseLocation);
        if (!RamlNodeUtils.isErrorResult(baseNode)) {
            new ExtensionsMerger(fragment == RamlFragment.Overlay).merge(baseNode, extensionNode);
            if (!RamlNodeUtils.isErrorResult(baseNode)) {
                List<Phase> phases = this.createPhases(resourceLoader, RamlFragment.Default);
                baseNode = this.runPhases(baseNode, phases, Integer.MAX_VALUE);
            }
        }
        return baseNode;
    }

    private List<Phase> createPhases(ResourceLoader resourceLoader, RamlFragment fragment) {
        TransformationPhase includePhase = new TransformationPhase(new Transformer[]{new IncludeResolver(resourceLoader), new StringTemplateExpressionTransformer()});
        TransformationPhase ramlFragmentsValidator = new TransformationPhase(new Transformer[]{new RamlFragmentGrammarTransformer()});
        TransformationPhase ramlFragmentsLibraryLinker = new TransformationPhase(new Transformer[]{new RamlFragmentLibraryLinkingTransformer(this, resourceLoader)});
        GrammarPhase grammarPhase = new GrammarPhase(RamlHeader.getFragmentRule(fragment));
        TransformationPhase libraryLink = new TransformationPhase(new Transformer[]{new LibraryLinkingTransformation(this, resourceLoader)});
        TransformationPhase referenceCheck = new TransformationPhase(new Transformer[]{new ReferenceResolverTransformer()});
        TransformationPhase resourcePhase = new TransformationPhase(new Transformer[]{new ResourceTypesTraitsTransformer(new Raml10GrammarUsesAllowed())});
        TransformationPhase duplicatedPaths = new TransformationPhase(new Transformer[]{new DuplicatedPathsTransformer()});
        TransformationPhase checkUnusedParameters = new TransformationPhase(new Transformer[]{new UnusedParametersTransformer()});
        TransformationPhase undefinedUriParameterInjection = new TransformationPhase(new Transformer[]{new ImplicitUriParametersInjectionTransformer()});
        AnnotationValidationPhase annotationValidationPhase = new AnnotationValidationPhase(resourceLoader);
        MediaTypeInjectionPhase mediaTypeInjection = new MediaTypeInjectionPhase();
        TransformationPhase schemaValidationPhase = new TransformationPhase(new Transformer[]{new SchemaValidationTransformer(resourceLoader)});
        TypeValidationPhase typeValidationPhase = new TypeValidationPhase();
        ExampleValidationPhase exampleValidationPhase = new ExampleValidationPhase(resourceLoader);
        return Arrays.asList(includePhase, ramlFragmentsValidator, ramlFragmentsLibraryLinker, grammarPhase, libraryLink, referenceCheck, resourcePhase, duplicatedPaths, checkUnusedParameters, undefinedUriParameterInjection, annotationValidationPhase, mediaTypeInjection, grammarPhase, schemaValidationPhase, typeValidationPhase, exampleValidationPhase);
    }
}

