/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;

public class CacheResourceLoader
implements ResourceLoaderExtended {
    private final Map<String, byte[]> resources = new HashMap<String, byte[]>();
    private ResourceLoader resourceLoader;

    public CacheResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        try {
            if (this.resources.containsKey(resourceName)) {
                byte[] resourceByteArray = this.resources.get(resourceName);
                return this.toInputStreamOrNull(resourceByteArray);
            }
            InputStream resource = this.resourceLoader instanceof ResourceLoaderExtended ? ((ResourceLoaderExtended)this.resourceLoader).fetchResource(resourceName, callback) : this.resourceLoader.fetchResource(resourceName);
            byte[] resourceByteArray = resource == null ? null : IOUtils.toByteArray((InputStream)resource);
            this.resources.put(resourceName, resourceByteArray);
            return this.toInputStreamOrNull(resourceByteArray);
        }
        catch (IOException e) {
            return this.resourceLoader.fetchResource(resourceName);
        }
    }

    private ByteArrayInputStream toInputStreamOrNull(byte[] resourceByteArray) {
        return resourceByteArray == null ? null : new ByteArrayInputStream(resourceByteArray);
    }
}

