/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.rules.TypesUtils;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.BooleanNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.snakeyaml.SYArrayNode;

public class BooleanResolvedType
extends XmlFacetsCapableType {
    private List<Boolean> enums = new ArrayList<Boolean>();

    public BooleanResolvedType(String typeName, TypeExpressionNode declarationNode, XmlFacets xmlFacets, ResolvedCustomFacets customFacets) {
        super(typeName, declarationNode, xmlFacets, customFacets);
    }

    public BooleanResolvedType(TypeExpressionNode from) {
        super(BooleanResolvedType.getTypeName(from, TypeId.BOOLEAN.getType()), from, new ResolvedCustomFacets(new String[0]));
    }

    @Override
    protected BooleanResolvedType copy() {
        return new BooleanResolvedType(this.getTypeName(), this.getTypeExpressionNode(), this.getXmlFacets().copy(), this.customFacets.copy());
    }

    @Override
    public void validateCanOverwriteWith(TypeDeclarationNode from) {
        this.customFacets.validate(from);
        Raml10Grammar raml10Grammar = new Raml10Grammar();
        AnyOfRule facetRule = new AnyOfRule(new Rule[0]).add((Rule)raml10Grammar.enumField()).addAll(this.customFacets.getRules());
        TypesUtils.validateAllWith((Rule)facetRule, from.getFacets());
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        BooleanResolvedType copy = this.copy();
        copy.customFacets = copy.customFacets().overwriteFacets(from);
        copy.setEnums(this.getEnumValues(from));
        return this.overwriteFacets(copy, from);
    }

    @Nonnull
    private List<Boolean> getEnumValues(Node typeNode) {
        Node values = typeNode.get("enum");
        ArrayList<Boolean> enumValues = new ArrayList<Boolean>();
        if (values != null && values instanceof SYArrayNode) {
            for (Node node : values.getChildren()) {
                if (!(node instanceof BooleanNode)) continue;
                enumValues.add(((BooleanNode)node).getValue());
            }
        }
        return enumValues;
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        BooleanResolvedType copy = this.copy();
        copy.customFacets = copy.customFacets().mergeWith(with.customFacets());
        if (with instanceof BooleanResolvedType) {
            copy.setEnums(((BooleanResolvedType)with).getEnums());
        }
        return this.mergeFacets(copy, with);
    }

    public void setEnums(List<Boolean> enums) {
        if (enums != null) {
            this.enums = enums;
        }
    }

    public List<Boolean> getEnums() {
        return this.enums;
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitBoolean(this);
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return TypeId.BOOLEAN.getType();
    }
}

