/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.nodes.PropertyNode;

public class PropertyFacets {
    private String name;
    private ResolvedType resolvedType;
    private boolean required;
    private PropertyNode propertyNode;

    public PropertyFacets(String name, ResolvedType resolvedType, Boolean required) {
        this.name = name;
        this.resolvedType = resolvedType;
        this.required = required;
    }

    public PropertyFacets(PropertyNode propertyNode) {
        this.name = propertyNode.getName();
        this.required = propertyNode.isRequired();
        this.propertyNode = propertyNode;
    }

    public String getName() {
        return this.name;
    }

    public ResolvedType getValueType() {
        if (this.resolvedType == null) {
            this.resolvedType = this.propertyNode.getTypeDefinition();
        }
        return this.resolvedType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isPatternProperty() {
        return this.name.startsWith("/") && this.name.endsWith("/");
    }

    @Nullable
    public String getPatternRegex() {
        if (this.isPatternProperty()) {
            return this.name.substring(1, this.name.length() - 1);
        }
        return null;
    }

    public PropertyFacets mergeFacets(PropertyFacets value) {
        return new PropertyFacets(this.name, this.getValueType().mergeFacets(value.getValueType()), this.required || value.isRequired());
    }
}

