/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.type.PropertyFacets;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeSelector;

public class ObjectResolvedType
extends XmlFacetsCapableType {
    private Integer minProperties;
    private Integer maxProperties;
    private Boolean additionalProperties;
    private String discriminator;
    private String discriminatorValue;
    private Map<String, PropertyFacets> properties = new LinkedHashMap<String, PropertyFacets>();

    public ObjectResolvedType(TypeDeclarationNode declarationNode, XmlFacets xmlFacets, Integer minProperties, Integer maxProperties, Boolean additionalProperties, String discriminator, String discriminatorValue, Map<String, PropertyFacets> properties) {
        super(declarationNode, xmlFacets);
        this.minProperties = minProperties;
        this.maxProperties = maxProperties;
        this.additionalProperties = additionalProperties;
        this.discriminator = discriminator;
        this.discriminatorValue = discriminatorValue;
        this.properties = properties;
    }

    public ObjectResolvedType(TypeDeclarationNode from) {
        super(from);
    }

    protected ObjectResolvedType copy() {
        return new ObjectResolvedType(this.getTypeDeclarationNode(), this.getXmlFacets().copy(), this.minProperties, this.maxProperties, this.additionalProperties, this.discriminator, this.discriminatorValue, new LinkedHashMap<String, PropertyFacets>(this.properties));
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        ObjectResolvedType result = this.copy();
        result.setMinProperties(NodeSelector.selectIntValue((String)"minProperties", (Node)from));
        result.setMaxProperties(NodeSelector.selectIntValue((String)"maxProperties", (Node)from));
        result.setAdditionalProperties(NodeSelector.selectBooleanValue((String)"additionalProperties", (Node)from));
        result.setDiscriminator(NodeSelector.selectStringValue((String)"discriminator", (Node)from));
        result.setDiscriminatorValue(NodeSelector.selectStringValue((String)"discriminatorValue", (Node)from));
        Node properties = from.get("properties");
        if (properties != null) {
            List children = properties.getChildren();
            for (Node child : children) {
                if (!(child instanceof PropertyNode)) continue;
                PropertyNode propertyNode = (PropertyNode)child;
                String name = propertyNode.getName();
                PropertyFacets propertyDefinition = new PropertyFacets(propertyNode);
                result.getProperties().put(name, propertyDefinition);
            }
        }
        return this.overwriteFacets(result, from);
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        ObjectResolvedType result = this.copy();
        if (with instanceof ObjectResolvedType) {
            result.setMinProperties(((ObjectResolvedType)with).getMinProperties());
            result.setMaxProperties(((ObjectResolvedType)with).getMaxProperties());
            result.setAdditionalProperties(((ObjectResolvedType)with).getAdditionalProperties());
            result.setDiscriminator(((ObjectResolvedType)with).getDiscriminator());
            result.setDiscriminatorValue(((ObjectResolvedType)with).getDiscriminatorValue());
            Map<String, PropertyFacets> properties = ((ObjectResolvedType)with).getProperties();
            for (Map.Entry<String, PropertyFacets> property : properties.entrySet()) {
                if (!this.getProperties().containsKey(property.getKey())) {
                    result.getProperties().put(property.getKey(), property.getValue());
                    continue;
                }
                PropertyFacets propertyDefinition = result.getProperties().get(property.getKey());
                result.getProperties().put(property.getKey(), propertyDefinition.mergeFacets(property.getValue()));
            }
        }
        return this.mergeFacets(result, with);
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitObject(this);
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public void setMinProperties(Integer minProperties) {
        if (minProperties != null) {
            this.minProperties = minProperties;
        }
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public void setMaxProperties(Integer maxProperties) {
        if (maxProperties != null) {
            this.maxProperties = maxProperties;
        }
    }

    public Boolean getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Boolean additionalProperties) {
        if (additionalProperties != null) {
            this.additionalProperties = additionalProperties;
        }
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(String discriminator) {
        if (discriminator != null) {
            this.discriminator = discriminator;
        }
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        if (discriminatorValue != null) {
            this.discriminatorValue = discriminatorValue;
        }
    }

    public Map<String, PropertyFacets> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, PropertyFacets> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties = properties;
        }
    }
}

