/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import java.util.List;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypeNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.v10.type.TypeToRuleVisitor;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.Phase;

public class AnnotationValidationPhase
implements Phase {
    private ResourceLoader resourceLoader;

    public AnnotationValidationPhase(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Node apply(Node tree) {
        List annotations = tree.findDescendantsWith(AnnotationNode.class);
        for (AnnotationNode annotation : annotations) {
            String annotationName = annotation.getName();
            AnnotationTypeNode annotationTypeNode = annotation.getAnnotationTypeNode();
            if (annotationTypeNode == null) {
                annotation.replaceWith(ErrorNodeFactory.createMissingAnnotationType((String)annotationName));
                continue;
            }
            TypeDeclarationNode typeNode = annotationTypeNode.getDeclaredType();
            Rule annotationRule = typeNode.getResolvedType().visit(new TypeToRuleVisitor(this.resourceLoader));
            Node annotationValue = annotation.getValue();
            annotationValue.replaceWith(annotationRule.apply(annotationValue));
        }
        return tree;
    }
}

