/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.io.IOException;
import java.io.InputStream;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.nodes.RamlTypedFragmentNode;
import org.raml.v2.internal.utils.ResourcePathUtils;
import org.raml.v2.internal.utils.StreamUtils;
import org.raml.yagi.framework.nodes.IncludeErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.nodes.snakeyaml.RamlNodeParser;
import org.raml.yagi.framework.nodes.snakeyaml.SYIncludeNode;
import org.raml.yagi.framework.phase.Transformer;

public class IncludeResolver
implements Transformer {
    private final ResourceLoader resourceLoader;

    public IncludeResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public boolean matches(Node node) {
        return node instanceof SYIncludeNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node transform(Node node) {
        SYIncludeNode includeNode = (SYIncludeNode)node;
        String resourcePath = ResourcePathUtils.toAbsoluteLocation(node.getStartPosition().getPath(), includeNode.getIncludePath());
        try (InputStream inputStream = this.resourceLoader.fetchResource(resourcePath);){
            Object result;
            if (inputStream == null) {
                IncludeErrorNode includeErrorNode = new IncludeErrorNode("Include cannot be resolved: " + resourcePath);
                return includeErrorNode;
            }
            String includeContent = StreamUtils.toString(inputStream);
            if (resourcePath.endsWith(".raml") || resourcePath.endsWith(".yaml") || resourcePath.endsWith(".yml")) {
                try {
                    RamlHeader ramlHeader = RamlHeader.parse(includeContent);
                    RamlFragment fragment = ramlHeader.getFragment();
                    result = RamlNodeParser.parse((ResourceLoader)this.resourceLoader, (String)resourcePath, (String)includeContent);
                    if (result != null && this.isTypedFragment((Node)result, fragment)) {
                        RamlTypedFragmentNode newNode = new RamlTypedFragmentNode(fragment);
                        result.replaceWith((Node)newNode);
                        result = newNode;
                    }
                }
                catch (RamlHeader.InvalidHeaderException e) {
                    result = RamlNodeParser.parse((ResourceLoader)this.resourceLoader, (String)resourcePath, (String)includeContent);
                }
            } else {
                result = new StringNodeImpl(includeContent);
            }
            if (result == null) {
                result = new IncludeErrorNode("Include file is empty: " + resourcePath);
            }
            Node node2 = result;
            return node2;
        }
        catch (IOException e) {
            return new IncludeErrorNode(String.format("Include cannot be resolved: %s. (%s)", resourcePath, e.getMessage()));
        }
    }

    private boolean isTypedFragment(Node result, RamlFragment fragment) {
        return fragment != null && fragment != RamlFragment.Library && result instanceof ObjectNode;
    }
}

