/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v08.grammar;

import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.grammar.rule.AnyOfRule;
import org.raml.v2.internal.framework.grammar.rule.KeyValueRule;
import org.raml.v2.internal.framework.grammar.rule.ObjectRule;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.grammar.rule.StringValueRule;
import org.raml.v2.internal.framework.nodes.StringNodeImpl;
import org.raml.v2.internal.impl.commons.grammar.BaseRamlGrammar;
import org.raml.v2.internal.impl.v10.nodes.types.factories.TypeNodeFactory;

public class Raml08Grammar
extends BaseRamlGrammar {
    @Override
    protected ObjectRule mimeType() {
        return this.objectType().with(this.field(this.string("schema"), this.scalarType())).with(this.field(this.string("formParameters"), this.formParameters())).with(this.field(this.string("example"), this.scalarType()));
    }

    protected Rule formParameters() {
        return this.objectType().with(this.field(this.scalarType(), this.anyOf(this.parameter(), this.array(this.parameter()))));
    }

    @Override
    protected ObjectRule resourceValue() {
        return super.resourceValue().with(this.field(this.string("baseUriParameters"), this.parameters()));
    }

    @Override
    protected ObjectRule methodValue() {
        return super.methodValue().with(this.field(this.string("baseUriParameters"), this.parameters()));
    }

    @Override
    protected AnyOfRule anyMethod() {
        return this.anyOf(super.anyMethod(), this.string("connect"));
    }

    @Override
    protected AnyOfRule anyOptionalMethod() {
        return this.anyOf(super.anyOptionalMethod(), this.string("connect?"));
    }

    @Override
    protected Rule parameter() {
        return this.objectType().with(this.field(this.typeKey(), this.typeOptions())).with(this.displayNameField()).with(this.descriptionField()).with(this.exampleField()).with(this.defaultField()).with(this.repeatField()).with(this.requiredField()).with(this.when("type", this.is(this.stringTypeLiteral()).add(this.patternField()).add(this.minLengthField()).add(this.maxLengthField()).add(this.enumField(this.scalarType())), this.is(this.numericTypeLiteral()).add(this.minimumField()).add(this.maximumField()).add(this.enumField(this.integerType())), this.is(this.fileTypeLiteral()).add(this.minLengthField()).add(this.maxLengthField())).defaultValue(new StringNodeImpl("string"))).then(new TypeNodeFactory());
    }

    private KeyValueRule defaultField() {
        return this.field(this.string("default"), this.any()).description("The default attribute specifies the default value to use for the property if the property is omitted or its value is not specified. This SHOULD NOT be interpreted as a requirement for the client to send the default attribute's value if there is no other value to send. Instead, the default attribute's value is the value the server uses if the client does not send a value.");
    }

    private KeyValueRule maximumField() {
        return this.field(this.string("maximum"), this.numberType()).description("The maximum attribute specifies the parameter's maximum value.");
    }

    private KeyValueRule minimumField() {
        return this.field(this.string("minimum"), this.numberType()).description("The minimum attribute specifies the parameter's minimum value.");
    }

    private KeyValueRule exampleField() {
        return this.field(this.string("example"), this.any()).description("The example attribute shows an example value for the property. This can be used, e.g., by documentation generators to generate sample values for the property.");
    }

    private KeyValueRule repeatField() {
        return this.field(this.string("repeat"), this.booleanType()).description("The repeat attribute specifies that the parameter can be repeated. If the parameter can be used multiple times, the repeat parameter value MUST be set to 'true'. Otherwise, the default value is 'false' and the parameter may not be repeated.");
    }

    private KeyValueRule requiredField() {
        return this.field(this.string("required"), this.booleanType()).description("The required attribute specifies whether the parameter and its value MUST be present in the API definition. It must be either 'true' if the value MUST be present or 'false' otherwise.\n\nIn general, parameters are optional unless the required attribute is included and its value set to 'true'.\n\nFor a URI parameter, the required attribute MAY be omitted, but its default value is 'true'.");
    }

    private KeyValueRule maxLengthField() {
        return this.field(this.string("maxLength"), this.integerType()).description("The maxLength attribute specifies the parameter value's maximum number of characters.");
    }

    private KeyValueRule minLengthField() {
        return this.field(this.string("minLength"), this.integerType()).description("The minLength attribute specifies the parameter value's minimum number of characters.");
    }

    private KeyValueRule enumField(Rule of) {
        return this.field(this.string("enum"), this.array(of)).description("The enum attribute provides an enumeration of the parameter's valid values. This MUST be an array. If the enum attribute is defined, API clients and servers MUST verify that a parameter's value matches a value in the enum array. If there is no matching value, the clients and servers MUST treat this as an error.");
    }

    private KeyValueRule patternField() {
        return this.field(this.string("pattern"), this.scalarType()).description("The pattern attribute is a regular expression that a parameter of type string MUST match. Regular expressions MUST follow the regular expression specification from ECMA 262/Perl 5. The pattern MAY be enclosed in double quotes for readability and clarity.");
    }

    private Rule typeOptions() {
        return this.anyOf(this.stringTypeLiteral(), this.numericTypeLiteral(), this.string("date"), this.fileTypeLiteral(), this.string("boolean"));
    }

    private StringValueRule fileTypeLiteral() {
        return this.string("file");
    }

    private Rule numericTypeLiteral() {
        return this.anyOf(this.string("number"), this.string("integer"));
    }

    private StringValueRule stringTypeLiteral() {
        return this.string("string");
    }

    @Override
    protected Rule schemasValue() {
        return this.anyOf(this.array(this.schemas()), this.schemas());
    }

    @Override
    @Nonnull
    protected String schemasDescription() {
        return "Collections of schemas that could be used anywhere in the API definition. The \"schemas\" property allows for XML and JSON schemas.";
    }

    @Override
    protected Rule traitsValue() {
        return this.anyOf(this.array(this.trait()), this.trait());
    }

    @Override
    protected Rule resourceTypesValue() {
        return this.anyOf(this.array(this.resourceTypes()), this.resourceTypes());
    }

    @Override
    protected Rule securitySchemesValue() {
        return this.anyOf(this.array(this.securitySchemes()), this.securitySchemes());
    }
}

