/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.raml.v2.internal.framework.nodes.ArrayNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.SimpleTypeNode;
import org.raml.v2.internal.impl.commons.model.StringType;
import org.raml.v2.internal.impl.commons.model.builder.ModelUtils;
import org.raml.v2.internal.utils.NodeSelector;

public abstract class BaseModelElement {
    protected abstract Node getNode();

    protected String getStringValue(String key) {
        return ModelUtils.getStringValue(key, this.getNode());
    }

    protected StringType getStringTypeValue(String key) {
        return ModelUtils.getStringTypeValue(key, this.getNode());
    }

    protected List<String> getStringList(String key) {
        ArrayList<String> result = new ArrayList<String>();
        Node node = NodeSelector.selectFrom(key, this.getNode());
        if (node != null) {
            if (node instanceof SimpleTypeNode) {
                result.add(((SimpleTypeNode)node).getLiteralValue());
            } else {
                for (Node child : node.getChildren()) {
                    result.add(String.valueOf(child));
                }
            }
        }
        return result;
    }

    protected <T> List<T> getListFromSeq(String key, Class<T> clazz) {
        ArrayList<T> resultList = new ArrayList<T>();
        Node parent = NodeSelector.selectFrom(key, this.getNode());
        if (parent != null) {
            if (parent instanceof ArrayNode) {
                return this.getList(key, clazz);
            }
            try {
                Constructor<T> constructor = clazz.getConstructor(Node.class);
                resultList.add(constructor.newInstance(parent));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }

    protected <T> List<T> getList(String key, Class<T> clazz) {
        ArrayList<T> resultList = new ArrayList<T>();
        Node parent = NodeSelector.selectFrom(key, this.getNode());
        if (parent != null) {
            for (Node child : parent.getChildren()) {
                try {
                    Constructor<T> constructor = clazz.getConstructor(Node.class);
                    resultList.add(constructor.newInstance(child));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return resultList;
    }

    protected <T> T getObject(String key, Class<T> clazz) {
        Node settings = NodeSelector.selectFrom(key, this.getNode());
        if (settings != null) {
            try {
                Constructor<T> constructor = clazz.getConstructor(Node.class);
                return constructor.newInstance(settings.getParent());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

