/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.phase;

import java.util.Arrays;
import java.util.List;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.phase.Phase;
import org.raml.v2.internal.framework.phase.Transformer;

public class TransformationPhase
implements Phase {
    private List<Transformer> transformers;

    public TransformationPhase(Transformer ... transformers) {
        this.transformers = Arrays.asList(transformers);
    }

    @Override
    public Node apply(Node tree) {
        Node result = tree;
        for (Transformer transformer : this.transformers) {
            if (!transformer.matches(result)) continue;
            result = transformer.transform(result);
        }
        if (tree != result && tree.getParent() != null) {
            tree.replaceWith(result);
        }
        for (Node node : result.getChildren()) {
            this.apply(node);
        }
        return result;
    }
}

