/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.nodes.snakeyaml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nullable;
import org.raml.v2.internal.framework.nodes.DefaultPosition;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYModelWrapper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class RamlNodeParser {
    @Nullable
    public static Node parse(InputStream inputStream) {
        return RamlNodeParser.parse(inputStream, false);
    }

    @Nullable
    public static Node parse(InputStream inputStream, boolean supportLibraries) {
        try {
            return RamlNodeParser.parse(new InputStreamReader(inputStream, "UTF-8"), supportLibraries);
        }
        catch (UnsupportedEncodingException e) {
            return RamlNodeParser.parse(new InputStreamReader(inputStream), supportLibraries);
        }
    }

    @Nullable
    public static Node parse(Reader reader) {
        return RamlNodeParser.parse(reader, false);
    }

    @Nullable
    public static Node parse(Reader reader, boolean supportLibraries) {
        try {
            Yaml yamlParser = new Yaml();
            org.yaml.snakeyaml.nodes.Node composedNode = yamlParser.compose(reader);
            if (composedNode == null) {
                return null;
            }
            return new SYModelWrapper(supportLibraries).wrap(composedNode);
        }
        catch (MarkedYAMLException e) {
            return RamlNodeParser.buildYamlErrorNode(e);
        }
    }

    private static Node buildYamlErrorNode(MarkedYAMLException e) {
        ErrorNode errorNode = new ErrorNode("Underlying error while parsing YAML syntax: '" + e.getMessage() + "'");
        Mark problemMark = e.getProblemMark();
        errorNode.setStartPosition(new DefaultPosition(problemMark.getIndex(), problemMark.getLine(), 0, ""));
        errorNode.setEndPosition(new DefaultPosition(problemMark.getIndex() + 1, problemMark.getLine(), problemMark.getColumn(), ""));
        return errorNode;
    }

    @Nullable
    public static Node parse(String content) {
        return RamlNodeParser.parse(new StringReader(content));
    }

    @Nullable
    public static Node parse(String content, boolean supportLibraries) {
        return RamlNodeParser.parse(new StringReader(content), supportLibraries);
    }
}

