/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.framework.grammar.rule.xml.LSInputImpl;
import org.raml.v2.internal.utils.StreamUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XsdResourceResolver
implements LSResourceResolver {
    private final String resourcePath;
    private final ResourceLoader resourceLoader;

    public XsdResourceResolver(ResourceLoader resourceLoader, String resourcePath) {
        this.resourceLoader = resourceLoader;
        this.resourcePath = resourcePath;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        byte[] content;
        String path = this.resolvePath(systemId);
        if (path == null || path.startsWith("http://") || path.startsWith("https://")) {
            return null;
        }
        InputStream inputStream = this.resourceLoader.fetchResource(path);
        if (inputStream == null) {
            return null;
        }
        try {
            content = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LSInputImpl input = new LSInputImpl(publicId, systemId, baseURI, new ByteArrayInputStream(content), StreamUtils.detectEncoding(content));
        return input;
    }

    private String resolvePath(String includePath) {
        int lastSlash = this.resourcePath.lastIndexOf("/");
        if (lastSlash != -1) {
            return this.resourcePath.substring(0, lastSlash + 1) + includePath;
        }
        return includePath;
    }
}

