/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;
import org.raml.v2.internal.utils.DateUtils;

public class DateValueRule
extends Rule {
    private String dateType;
    private String rfc;

    public DateValueRule(String dateType, String rfc) {
        this.dateType = dateType;
        this.rfc = rfc;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            if (DateUtils.isValidDate(((StringNode)node).getValue(), this.dateType, this.rfc)) {
                return node;
            }
            return ErrorNodeFactory.createInvalidDateValue(((StringNode)node).getValue(), this.dateType, this.rfc);
        }
        return ErrorNodeFactory.createInvalidNode(node);
    }

    @Override
    public String getDescription() {
        return "Multiple of value";
    }
}

