/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.v10.phase;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.grammar.rule.ErrorNodeFactory;
import org.raml.v2.impl.commons.model.BuiltInScalarType;
import org.raml.v2.impl.commons.nodes.PropertyNode;
import org.raml.v2.impl.v10.nodes.types.InheritedPropertiesInjectedNode;
import org.raml.v2.impl.v10.nodes.types.builtin.ObjectTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.TypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.UnionTypeNode;
import org.raml.v2.nodes.ErrorNode;
import org.raml.v2.nodes.KeyValueNode;
import org.raml.v2.nodes.KeyValueNodeImpl;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.SchemaNodeImpl;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.nodes.StringNodeImpl;
import org.raml.v2.nodes.snakeyaml.SYArrayNode;
import org.raml.v2.nodes.snakeyaml.SYNullNode;
import org.raml.v2.nodes.snakeyaml.SYObjectNode;
import org.raml.v2.nodes.snakeyaml.SYStringNode;
import org.raml.v2.phase.Transformer;
import org.raml.v2.utils.NodeUtils;
import org.raml.v2.utils.SchemaGenerator;

public class TypesTransformer
implements Transformer {
    private String actualPath;

    public TypesTransformer(String actualPath) {
        this.actualPath = actualPath;
    }

    public TypesTransformer() {
    }

    @Override
    public boolean matches(Node node) {
        return node instanceof ObjectTypeNode;
    }

    @Override
    public Node transform(Node node) {
        if (node instanceof StringNode && SchemaGenerator.isSchemaNode(node)) {
            SchemaGenerator.wrapNode(node, this.actualPath);
        } else if (node instanceof UnionTypeNode) {
            this.transformUnionTypeProperties(node);
        } else if (node instanceof ObjectTypeNode && NodeUtils.getType(node) instanceof SYArrayNode) {
            this.transformObjectTypeProperties(node);
        }
        this.validateGeneratedProperties(node);
        return node;
    }

    private void validateGeneratedProperties(Node node) {
        if (node instanceof ObjectTypeNode) {
            ObjectTypeNode objectNode = (ObjectTypeNode)node;
            Integer totalNumberOfProperties = this.getNumberOfProperties(node);
            if (objectNode.getMinProperties() != null && objectNode.getMinProperties().compareTo(totalNumberOfProperties) > 0) {
                node.replaceWith(ErrorNodeFactory.createInvalidNumberOfProperties("minimum", objectNode.getMinProperties(), totalNumberOfProperties));
            }
            if (objectNode.getMaxProperties() != null && objectNode.getMaxProperties().compareTo(totalNumberOfProperties) < 0) {
                node.replaceWith(ErrorNodeFactory.createInvalidNumberOfProperties("maximum", objectNode.getMaxProperties(), totalNumberOfProperties));
            }
        }
    }

    private Integer getNumberOfProperties(Node node) {
        Node properties = node.get("properties");
        if (properties == null) {
            return 0;
        }
        return properties.getChildren().size();
    }

    private void transformObjectTypeProperties(Node node) {
        Node properties = node.get("properties");
        SYArrayNode typesNode = (SYArrayNode)NodeUtils.getType(node);
        if (typesNode != null) {
            Set<List<String>> typeCombinations = this.validateAndGetPossibleTypes(typesNode);
            for (List<String> combination : typeCombinations) {
                Node originalProperties = properties != null ? properties.copy() : null;
                for (String objectTypeName : combination) {
                    originalProperties = this.processType(originalProperties, node, objectTypeName);
                }
                this.injectProperties((ObjectTypeNode)node, new StringNodeImpl(combination.toString()), (SYObjectNode)originalProperties);
            }
        }
    }

    private Node processType(Node originalProperties, Node context, String objectType) {
        TypeNode typeNode = NodeUtils.getType(objectType, context);
        if (typeNode instanceof ObjectTypeNode) {
            if (originalProperties == null) {
                SYObjectNode newProperties = (SYObjectNode)typeNode.get("properties");
                if (newProperties != null) {
                    originalProperties = newProperties.copy();
                }
            } else {
                List<PropertyNode> unionProperties = this.getTypeProperties((ObjectTypeNode)typeNode);
                this.addProperties(originalProperties, unionProperties);
            }
        }
        return originalProperties;
    }

    private void transformUnionTypeProperties(Node node) {
        StringNode typeNode = (StringNode)NodeUtils.getType(node);
        if (SchemaGenerator.isSchemaNode(node)) {
            SchemaGenerator.wrapNode(node, this.actualPath);
            return;
        }
        this.validateInheritedTypes(typeNode);
        Node properties = node.get("properties");
        if (properties != null) {
            if (typeNode != null) {
                for (String type : typeNode.getValue().split("\\|")) {
                    String trimmedType = StringUtils.trim((String)type);
                    Node unionProperties = this.processType(properties.copy(), node, trimmedType);
                    if (unionProperties == null || unionProperties instanceof SYNullNode) continue;
                    this.injectProperties((ObjectTypeNode)node, new StringNodeImpl(trimmedType), (SYObjectNode)unionProperties);
                }
            }
        } else if (NodeUtils.getType(node) instanceof StringNode) {
            String trimmedType = StringUtils.trim((String)((StringNode)NodeUtils.getType(node)).getValue());
            if ("array".equals(trimmedType)) {
                return;
            }
            if (SchemaGenerator.isSchemaNode(NodeUtils.getType(node))) {
                SchemaGenerator.wrapNode(NodeUtils.getType(node), this.actualPath);
                return;
            }
            TypeNode parentTypeNodeGeneral = NodeUtils.getType(trimmedType, typeNode);
            if (parentTypeNodeGeneral instanceof ObjectTypeNode) {
                ObjectTypeNode parentTypeNode = (ObjectTypeNode)parentTypeNodeGeneral;
                if (parentTypeNode.get("properties") != null) {
                    this.injectProperties((ObjectTypeNode)node, new StringNodeImpl(trimmedType), (SYObjectNode)parentTypeNode.get("properties"));
                }
                if (!parentTypeNode.getInheritedProperties().isEmpty()) {
                    ((ObjectTypeNode)node).setInheritedProperties(parentTypeNode.getInheritedProperties());
                } else if (SchemaGenerator.isSchemaNode(NodeUtils.getType(parentTypeNode))) {
                    SchemaNodeImpl schemaNode = new SchemaNodeImpl((StringNodeImpl)NodeUtils.getType(parentTypeNode), this.actualPath);
                    NodeUtils.getType(node).replaceWith(schemaNode);
                    return;
                }
            }
        }
    }

    private void validateInheritedTypes(StringNode typeNode) {
        if (typeNode != null && this.isCustomRamlType(typeNode) && !SchemaGenerator.isSchemaNode(typeNode)) {
            for (String type : typeNode.getValue().split("\\|")) {
                String trimmedType = StringUtils.trim((String)type);
                TypeNode parentTypeNode = NodeUtils.getType(trimmedType, typeNode);
                if (parentTypeNode != null) continue;
                ErrorNode errorNode = ErrorNodeFactory.createInexistentType(trimmedType);
                typeNode.replaceWith(errorNode);
            }
        }
    }

    private boolean isCustomRamlType(StringNode typeNode) {
        String typeNodeValue = typeNode.getValue();
        return !BuiltInScalarType.isBuiltInScalarType(typeNodeValue) && !typeNodeValue.equals("array") && !typeNodeValue.equals("object") && !SchemaGenerator.isSchemaNode(typeNode);
    }

    private void addProperties(Node properties, List<PropertyNode> unionProperties) {
        if (unionProperties != null) {
            for (PropertyNode property : unionProperties) {
                Node existingProperty = properties.get(property.getName());
                if (existingProperty != null) {
                    ErrorNode errorNode = new ErrorNode("property definition {" + existingProperty.getParent() + "} overrides existing property: {" + property + "}");
                    errorNode.setSource(existingProperty);
                    properties.addChild(errorNode);
                    continue;
                }
                properties.addChild(property);
            }
        }
    }

    private Set<List<String>> validateAndGetPossibleTypes(SYArrayNode typesNode) {
        ArrayList types = Lists.newArrayList();
        for (Node typeNode : typesNode.getChildren()) {
            String typeElement = ((SYStringNode)typeNode).getValue();
            LinkedHashSet splitTypes = Sets.newLinkedHashSet();
            for (String type : typeElement.split("\\|")) {
                if (!StringUtils.isNotBlank((String)StringUtils.trimToNull((String)type))) continue;
                String objectType = StringUtils.trim((String)type);
                TypeNode typeDefinition = NodeUtils.getType(objectType, typeNode);
                if (typeDefinition == null) {
                    ErrorNode error = ErrorNodeFactory.createInexistentType(objectType);
                    typeNode.replaceWith(error);
                    continue;
                }
                splitTypes.add(objectType);
            }
            types.add(splitTypes);
        }
        return Sets.cartesianProduct((List)types);
    }

    private List<PropertyNode> getTypeProperties(ObjectTypeNode node) {
        return node.getProperties();
    }

    private void injectProperties(ObjectTypeNode node, StringNodeImpl key, SYObjectNode properties) {
        InheritedPropertiesInjectedNode injected = new InheritedPropertiesInjectedNode();
        KeyValueNodeImpl keyValue = new KeyValueNodeImpl(key, properties);
        this.setKeyPosition(key, properties, injected, keyValue);
        injected.setParent(node);
        node.addInheritedProperties(injected);
    }

    private void setKeyPosition(StringNodeImpl key, SYObjectNode properties, Node injected, KeyValueNode keyValue) {
        key.setEndPosition(properties.getStartPosition());
        key.setStartPosition(properties.getStartPosition().leftShift(key.getValue().length()));
        injected.addChild(keyValue);
    }
}

