/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons.nodes;

import javax.annotation.Nonnull;
import org.raml.v2.impl.v10.nodes.types.builtin.TypeNode;
import org.raml.v2.nodes.KeyValueNodeImpl;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.ReferenceNode;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.utils.NodeUtils;

public class PropertyNode
extends KeyValueNodeImpl {
    public PropertyNode() {
    }

    public PropertyNode(PropertyNode node) {
        super(node);
    }

    public String getName() {
        StringNode key = (StringNode)this.getKey();
        String keyValue = key.getValue();
        return keyValue.endsWith("?") ? keyValue.substring(0, keyValue.length() - 1) : keyValue;
    }

    public boolean isRequired() {
        StringNode key = (StringNode)this.getKey();
        return !key.getValue().endsWith("?");
    }

    public TypeNode getTypeNode() {
        Node value = this.getValue();
        if (value instanceof TypeNode) {
            return (TypeNode)value;
        }
        if (value instanceof ReferenceNode) {
            return (TypeNode)((ReferenceNode)value).getRefNode();
        }
        throw new IllegalStateException("Value should be a TypeNode or a Reference to a TypeNode");
    }

    @Override
    @Nonnull
    public Node copy() {
        return new PropertyNode(this);
    }

    @Override
    public String toString() {
        return this.getName() + ":" + NodeUtils.getType(this.getValue());
    }
}

