/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons.model;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.raml.v2.impl.commons.model.StringType;
import org.raml.v2.impl.commons.model.builder.ModelUtils;
import org.raml.v2.nodes.Node;
import org.raml.v2.utils.NodeSelector;

public abstract class BaseModelElement {
    protected abstract Node getNode();

    protected String getStringValue(String key) {
        return ModelUtils.getStringValue(key, this.getNode());
    }

    protected StringType getStringTypeValue(String key) {
        return ModelUtils.getStringTypeValue(key, this.getNode());
    }

    protected <T> List<T> getList(String key, Class<T> clazz) {
        ArrayList<T> resultList = new ArrayList<T>();
        Node parent = NodeSelector.selectFrom(key, this.getNode());
        if (parent != null) {
            List<Object> nodes = new ArrayList<Node>();
            if (parent.getChildren().isEmpty()) {
                nodes.add(parent);
            } else {
                nodes = parent.getChildren();
            }
            for (Node node : nodes) {
                try {
                    Constructor<T> constructor = clazz.getConstructor(Node.class);
                    resultList.add(constructor.newInstance(node));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return resultList;
    }
}

