/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.grammar.rule.ErrorNodeFactory;
import org.raml.v2.grammar.rule.Rule;
import org.raml.v2.impl.commons.nodes.ExampleTypeNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.nodes.snakeyaml.SYObjectNode;
import org.raml.v2.suggester.RamlParsingContext;
import org.raml.v2.suggester.Suggestion;
import org.raml.v2.utils.SchemaGenerator;

public class JsonSchemaValidationRule
extends Rule {
    private JsonSchema schema;

    public JsonSchemaValidationRule(Node schemaNode) {
        try {
            this.schema = new SchemaGenerator().generateJsonSchema(schemaNode);
        }
        catch (Exception e) {
            this.schema = null;
        }
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Lists.newArrayList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return false;
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.schema == null) {
            return ErrorNodeFactory.createInvalidJsonExampleNode("Invalid JsonSchema");
        }
        try {
            Node source = node.getSource();
            if (source == null) {
                if (!(node instanceof StringNode) && !(node instanceof ObjectNode)) {
                    return ErrorNodeFactory.createInvalidJsonExampleNode("Source was null");
                }
                source = node;
            }
            String value = null;
            if (source instanceof StringNode) {
                value = ((StringNode)source).getValue();
            } else if (source instanceof SYObjectNode) {
                value = ((ExampleTypeNode)node).toJsonString();
            }
            if (value == null) {
                return ErrorNodeFactory.createInvalidJsonExampleNode("Source example is not valid: " + source);
            }
            JsonNode json = JsonLoader.fromString((String)value);
            ProcessingReport report = this.schema.validate(json);
            if (!report.isSuccess()) {
                Iterator iterator = report.iterator();
                ArrayList errors = Lists.newArrayList();
                while (iterator.hasNext()) {
                    ProcessingMessage next = (ProcessingMessage)iterator.next();
                    errors.add(next.getMessage());
                }
                node.replaceWith(ErrorNodeFactory.createInvalidJsonExampleNode("{\n" + Joiner.on((String)",\n").join((Iterable)errors) + "\n}"));
            }
        }
        catch (ProcessingException | IOException e) {
            node.replaceWith(ErrorNodeFactory.createInvalidNode(node));
        }
        return node;
    }

    @Override
    public String getDescription() {
        return "JSON Schema validation rule";
    }
}

