/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.grammar.rule.Rule;
import org.raml.v2.nodes.Node;
import org.raml.v2.suggester.RamlParsingContext;
import org.raml.v2.suggester.Suggestion;

public class DiscriminatorRule
extends Rule {
    private Rule discriminator;
    private Rule delegate;

    public DiscriminatorRule(Rule discriminator, Rule delegate) {
        this.discriminator = discriminator;
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        List<Node> children = node.getChildren();
        if (children.isEmpty() || this.discriminator.matches(children.get(0))) {
            return this.delegate.getSuggestions(node, context);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        List<Node> children = node.getChildren();
        boolean matches = this.delegate.matches(node);
        return matches && (children.isEmpty() || this.discriminator.matches(children.get(0)));
    }

    @Override
    public Node apply(@Nonnull Node node) {
        return this.delegate.apply(node);
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }
}

