/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify.resultparser;

import java.sql.ResultSet;
import java.util.Optional;
import org.r10r.sqlify.resultparser.ResultParser;
import org.r10r.sqlify.rowparser.RowParser;
import org.r10r.sqlify.rowparser.RowParsers;

public class SingleOptionalResultParser<T>
implements ResultParser<Optional<T>> {
    private final RowParser<T> rowParser;

    private SingleOptionalResultParser(RowParser<T> rowParser) {
        this.rowParser = rowParser;
    }

    public static <E> SingleOptionalResultParser<E> of(RowParser<E> rowParser) {
        return new SingleOptionalResultParser<E>(rowParser);
    }

    public static <E> SingleOptionalResultParser<E> of(Class<E> clazz) {
        RowParser rowParser = RowParsers.getDefaultParserFor(clazz);
        return new SingleOptionalResultParser(rowParser);
    }

    @Override
    public Optional<T> parseResultSet(ResultSet resultSet) throws Exception {
        Optional optional;
        if (resultSet.next()) {
            T t = this.rowParser.parse(resultSet);
            optional = Optional.of(t);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

