/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.r10r.sqlify.core.Batch;
import org.r10r.sqlify.core.SqlifyBatched;
import org.r10r.sqlify.core.SqlifySingle;
import org.r10r.sqlify.resultparser.ResultParser;

public final class Sqlify {
    public static <E> Builder sql(String sql) {
        return new Builder(sql);
    }

    public static BatchBuilder sqlBatch(String sql) {
        return new BatchBuilder(sql);
    }

    public static class BatchBuilder {
        private final String sql;
        private final List<Batch> batches;

        private BatchBuilder(String sql) {
            this.sql = sql;
            this.batches = new ArrayList<Batch>();
        }

        public BatchBuilder withBatches(List<Batch> batches) {
            this.batches.addAll(batches);
            return this;
        }

        public int[] executeUpdate(Connection connection) {
            SqlifyBatched sqlifyBatched = new SqlifyBatched(this.sql, this.batches);
            return sqlifyBatched.executeUpdateBatch(connection);
        }
    }

    public static class Builder {
        private final String sql;
        private final Map<String, Object> parameterMap;
        private ResultParser<?> resultParser;

        private Builder(String sql) {
            this.sql = sql;
            this.parameterMap = new HashMap<String, Object>();
        }

        public Builder withParameter(String key, Object value) {
            this.parameterMap.put(key, value);
            return this;
        }

        public Builder parseResultWith(ResultParser<?> resultParser) {
            this.resultParser = resultParser;
            return this;
        }

        public <E> E executeSelect(Connection connection) {
            SqlifySingle sqlifySingle = new SqlifySingle(this.sql, this.resultParser, this.parameterMap);
            return (E)sqlifySingle.executeSelect(connection);
        }

        public int executeUpdate(Connection connection) {
            SqlifySingle sqlifySingle = new SqlifySingle(this.sql, this.resultParser, this.parameterMap);
            return sqlifySingle.executeUpdate(connection);
        }

        public <E> E executeUpdateAndReturnGeneratedKey(Connection connection) {
            SqlifySingle sqlifySingle = new SqlifySingle(this.sql, this.resultParser, this.parameterMap);
            return (E)sqlifySingle.executeUpdateAndReturnGeneratedKey(connection);
        }
    }
}

