/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.ssl;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import quickfix.ConfigError;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.mina.ssl.SSLConfig;

public class SSLSupport {
    public static final String FILTER_NAME = "SslFilter";
    public static final String SETTING_USE_SSL = "SocketUseSSL";
    public static final String SETTING_KEY_STORE_PWD = "SocketKeyStorePassword";
    public static final String SETTING_KEY_STORE_NAME = "SocketKeyStore";
    public static final String SETTING_KEY_MANAGER_FACTORY_ALGORITHM = "KeyManagerFactoryAlgorithm";
    public static final String SETTING_KEY_STORE_TYPE = "KeyStoreType";
    public static final String SETTING_TRUST_STORE_PWD = "SocketTrustStorePassword";
    public static final String SETTING_TRUST_STORE_NAME = "SocketTrustStore";
    public static final String SETTING_TRUST_MANAGER_FACTORY_ALGORITHM = "TrustManagerFactoryAlgorithm";
    public static final String SETTING_TRUST_STORE_TYPE = "TrustStoreType";
    public static final String SETTING_NEED_CLIENT_AUTH = "NeedClientAuth";
    public static final String SETTING_ENDPOINT_IDENTIFICATION_ALGORITHM = "EndpointIdentificationAlgorithm";
    public static final String SETTING_ENABLED_PROTOCOLS = "EnabledProtocols";
    public static final String SETTING_CIPHER_SUITES = "CipherSuites";
    static final String DEFAULT_STORE_TYPE = "JKS";
    static final String DEFAULT_KEY_STORE_MANAGER_ALGORITHM = "SunX509";
    static final String DEFAULT_TRUST_STORE_MANAGER_ALGORITHM = "PKIX";
    static final String QUICKFIXJ_KEY_STORE = "quickfixj.keystore";
    static final String QUICKFIXJ_KEY_STORE_PWD = "quickfixjpw";

    public static String[] getDefaultCipherSuites(SSLContext sslContext) {
        return sslContext.getSocketFactory().getDefaultCipherSuites();
    }

    public static String[] getEnabledCipherSuites(SessionSettings sessionSettings, SessionID sessionID) {
        String enabledCipherSuites = SSLSupport.getString(sessionSettings, sessionID, SETTING_CIPHER_SUITES, null);
        if (enabledCipherSuites != null) {
            return enabledCipherSuites.split(",");
        }
        return null;
    }

    public static String[] getEnabledProtocols(SessionSettings sessionSettings, SessionID sessionID) {
        String enabledProtocols = SSLSupport.getString(sessionSettings, sessionID, SETTING_ENABLED_PROTOCOLS, null);
        if (enabledProtocols != null) {
            return enabledProtocols.split(",");
        }
        return null;
    }

    public static String getKeyManagerFactoryAlgorithm(SessionSettings sessionSettings, SessionID sessionID) {
        return SSLSupport.getString(sessionSettings, sessionID, SETTING_KEY_MANAGER_FACTORY_ALGORITHM, DEFAULT_KEY_STORE_MANAGER_ALGORITHM);
    }

    public static String getKeyStoreName(SessionSettings sessionSettings, SessionID sessionID) {
        return SSLSupport.getString(sessionSettings, sessionID, SETTING_KEY_STORE_NAME, QUICKFIXJ_KEY_STORE);
    }

    public static char[] getKeyStorePassword(SessionSettings sessionSettings, SessionID sessionID) {
        String keyStorePassword = SSLSupport.getString(sessionSettings, sessionID, SETTING_KEY_STORE_PWD, QUICKFIXJ_KEY_STORE_PWD);
        return keyStorePassword != null ? keyStorePassword.toCharArray() : null;
    }

    public static String getKeyStoreType(SessionSettings sessionSettings, SessionID sessionID) {
        return SSLSupport.getString(sessionSettings, sessionID, SETTING_KEY_STORE_TYPE, DEFAULT_STORE_TYPE);
    }

    public static String[] getSupportedProtocols(SSLContext sslContext) {
        try {
            return ((SSLSocket)sslContext.getSocketFactory().createSocket()).getSupportedProtocols();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static SSLConfig getSslConfig(SessionSettings sessionSettings, SessionID sessionID) {
        SSLConfig sslConfig = new SSLConfig();
        sslConfig.setKeyStoreName(SSLSupport.getKeyStoreName(sessionSettings, sessionID));
        sslConfig.setKeyStorePassword(SSLSupport.getKeyStorePassword(sessionSettings, sessionID));
        sslConfig.setKeyManagerFactoryAlgorithm(SSLSupport.getKeyManagerFactoryAlgorithm(sessionSettings, sessionID));
        sslConfig.setKeyStoreType(SSLSupport.getKeyStoreType(sessionSettings, sessionID));
        sslConfig.setTrustStoreName(SSLSupport.getTrustStoreName(sessionSettings, sessionID));
        sslConfig.setTrustStorePassword(SSLSupport.getTrustStorePassword(sessionSettings, sessionID));
        sslConfig.setTrustManagerFactoryAlgorithm(SSLSupport.getTrustManagerFactoryAlgorithm(sessionSettings, sessionID));
        sslConfig.setTrustStoreType(SSLSupport.getTrustStoreType(sessionSettings, sessionID));
        sslConfig.setEnabledCipherSuites(SSLSupport.getEnabledCipherSuites(sessionSettings, sessionID));
        sslConfig.setEnabledProtocols(SSLSupport.getEnabledProtocols(sessionSettings, sessionID));
        sslConfig.setNeedClientAuth(SSLSupport.isNeedClientAuth(sessionSettings, sessionID));
        sslConfig.setEndpointIdentificationAlgorithm(SSLSupport.getEndpointIdentificationAlgorithm(sessionSettings, sessionID));
        return sslConfig;
    }

    private static String getString(SessionSettings sessionSettings, SessionID sessionID, String key, String defaultValue) {
        String propertyValue = defaultValue;
        if (sessionSettings.isSetting(sessionID, key)) {
            try {
                propertyValue = sessionSettings.getString(sessionID, key);
            }
            catch (ConfigError configError) {
                // empty catch block
            }
        }
        return propertyValue;
    }

    public static String getTrustManagerFactoryAlgorithm(SessionSettings sessionSettings, SessionID sessionID) {
        return SSLSupport.getString(sessionSettings, sessionID, SETTING_TRUST_MANAGER_FACTORY_ALGORITHM, DEFAULT_TRUST_STORE_MANAGER_ALGORITHM);
    }

    public static String getTrustStoreName(SessionSettings sessionSettings, SessionID sessionID) {
        return SSLSupport.getString(sessionSettings, sessionID, SETTING_TRUST_STORE_NAME, null);
    }

    public static char[] getTrustStorePassword(SessionSettings sessionSettings, SessionID sessionID) {
        String trustStorePassword = SSLSupport.getString(sessionSettings, sessionID, SETTING_TRUST_STORE_PWD, null);
        return trustStorePassword != null ? trustStorePassword.toCharArray() : null;
    }

    public static String getTrustStoreType(SessionSettings sessionSettings, SessionID sessionID) {
        return SSLSupport.getString(sessionSettings, sessionID, SETTING_TRUST_STORE_TYPE, DEFAULT_STORE_TYPE);
    }

    public static boolean isNeedClientAuth(SessionSettings sessionSettings, SessionID sessionID) {
        return "Y".equals(SSLSupport.getString(sessionSettings, sessionID, SETTING_NEED_CLIENT_AUTH, "N"));
    }

    public static String getEndpointIdentificationAlgorithm(SessionSettings sessionSettings, SessionID sessionID) {
        return SSLSupport.getString(sessionSettings, sessionID, SETTING_ENDPOINT_IDENTIFICATION_ALGORITHM, null);
    }
}

